###
# Common launch point for both self contained executables
# and gort's launched by foreign Tcl shells
###
if {[llength $argv]==0} {
  set keyword shell
} else {
  set keyword [lindex $argv 0]
}
###
# Handle files dropped on executable
###
switch {[file extension $keyword]} {
  Smakefile {
    set argv [lrange $argv 1 end]
    source [file join $::SRCDIR .. apps smake.tcl]
    exit
  }
  .tcl {
    # Execute a raw tcl script
    set argv [lrange $argv 1 end]
    source [lindex $args 1]
    exit 0
  }
  .txt {
   # Spawn our editor
    set argv [lrange $argv 1 end]
    source [file join $::SRCDIR .. apps e.tcl]
    vwait forever
    exit
  }
  .sqlite {
    source [file join $::SRCDIR .. apps sqlite.tcl]
    exit
  }
}
###
# Handle external aliases to embedded executable
###
switch $keyword {
  critcl {
    package require critcl::app
    critcl::app::main [lrange $argv 1 end]
    exit
  }
  edit {
    # Spawn our editor
    set argv [lrange $argv 1 end]
    source [file join $::SRCDIR .. apps e.tcl]
    vwait forever
    exit
  }
  tkdiff -
  diff {
    # Spawn our editor
    set argv [lrange $argv 1 end]
    source [file join $::SRCDIR .. apps tkdiff.tcl]
    vwait forever
    exit 
  }
  rmdir -
  rm {
    set argv [lrange $argv 1 end]
    source [file join $::SRCDIR .. apps rmdir.tcl]
    exit 
  }
  scgi -
  server {
    # Our embedded webserver
    source [file join $::SRCDIR .. apps server.tcl]
    exit 0    
  }
  shell {
    # Our interactive shell
    source [file join $::SRCDIR .. apps shell.tcl]
    exit 0
  }
  smake {
    set argv [lrange $argv 1 end]
    source [file join $::SRCDIR .. apps smake.tcl]
    exit
  }
  sqlite {
    set argv [lrange $argv 1 end]
    source [file join $::SRCDIR .. apps sqlite.tcl]
    exit
  }
  tcl {
    set argv [lrange $argv 1 end]
    source [lindex $args 1]
    exit 0 
  }
}
package require gort
::tool::pathload [file join $::SRCDIR command] {baseclass.tcl}

# Something may have overwritten keyword
if {[llength $argv]==0} {
  set keyword shell
} else {
  set keyword [lindex $argv 0]
}
if {[info exists ::shell::cname($keyword)]} {
  set keyword $::shell::cname($keyword)
}
set ans [::command::[lindex $keyword 0] {*}[lrange $keyword 1 end] {*}[lrange $argv 1 end]]
puts $ans
exit 0
