#! /bin/sh
# The next line is executed by /bin/sh, but not tcl \
exec tclsh $0 ${1+"$@"}

###
# Load configuration
###
set appname [lindex $argv 0]

set here [file dirname [file normalize [info script]]]
set ::gort(exec)  [info nameofexecutable]
set ::gort(tclsh) [info nameofexecutable]
set ::gort(main)  [file normalize [info script]]
set ::gort(self-contained)  1
set ::gort(home)  $::SRCDIR
set ::gort(modules) [file join $::SRCDIR modules]

if {[namespace exists ::starkit]} {
  ###
  # Running inside a starkit
  ##
  set ::SRCDIR $::starkit::topdir
} else {
  # Otherwise SRCDIR is populated by ZipVFS
  namespace eval ::starkit {}
  set ::starkit::topdir $::SRCDIR
}
set dir $::SRCDIR
if {[file exists [file join $::SRCDIR/package.tcl]]} {
  source [file join $::SRCDIR/package.tcl]
} else {
  set ::auto_path [list $::SRCDIR [file join $::SRCDIR boot tcl] [file join $::SRCDIR boot tk] [file join $::SRCDIR modules] [file join $::SRCDIR teapot]]
}

proc gort_exec args {
  exec $::gort(tclsh) {*}$args
}

package require gort
source $::SRCDIR/shell.tcl



