::namespace eval ::command {}
::namespace eval ::command::vfs {}

###
# topic: 0d0a9fb7aaa3b7903aeb5e91a596e901f3d23a5a
# title: Install a package to a VFS
###
proc ::command::vfs::install {vfs args} {
  global odie modules
  if { $vfs eq {} } {
    set vfs [file join $::gort(sandbox) vfs-install]
  }
  set vfs [file normalize $vfs]
  if {[llength [lindex $args 0]] > 1 } {
    set pkglist [lindex $args 0]
  } else {
    set pkglist $args
  }
  foreach mod $pkglist {
    ::command::recipe::do $mod gort_vfs_install $vfs
  }
}

###
# topic: 02a40ceffa386e8f1ad431600db894d8873af8f7
# title: Build a master package manifest for a VFS
###
proc ::command::vfs::mkindex base {
  package require codebale
  global modules odie
  set stack {}
  set idxfile [file join $base packages.tcl]
  if {[file exists $idxfile]} {
    file delete $idxfile
  }
  
  set stack {}
  set buffer {
  set ::SRCDIR [file dirname [file normalize [info script]]]
  namespace eval ::starkit {
    variable topdir
    set topdir $::SRCDIR
  }
  }
  append buffer {
set dir [file dirname [file normalize [info script]]]
  }
  append buffer [::codebale::pkgindex_path $base] 
  set fout [open $idxfile w]
  puts $fout {# Tcl package index file, version 1.1
# This file is generated by the "gort" command
# and sourced either when an application starts up.
# It invokes the
# "package ifneeded" command to set up package-related
# information so that packages will be loaded automatically
# in response to "package require" commands.  When this
# script is sourced, the variable $SRCDIR is derived from
# the present location of the script.
# This system defers to any existing pkgIndex.tcl scripts
# that exist in the path, as they may contain addition setup
# logic.
  }
  puts $fout $buffer
  close $fout
  ###
  # Build a manifest of all packages in the VFS
  ###
  set manfile [file join $base manifest.txt]
  set mout [open $manfile w]
  set pkgdat [::codebale::pkgindex_manifest $base]
  foreach {package version} [lsort -stride 2 -dictionary $pkgdat] {
    puts $mout [list package $package $version]
  }
  close $mout
}

namespace eval ::gort::mkvfs {}

##
# topic: c592732bb435d83ab1f70259fc56dbd7
###
proc ::gort::mkvfs::cat fname {
    set fname [open $fname r]
    set data [read $fname]
    close $fname
    return $data
}

###
# topic: 64319f4600fb63c82b2258d908f9d066
# description: Script to build the VFS file system
###
proc ::gort::mkvfs::copyDir {d1 d2} {

    puts [format {%*sCreating %s} [expr {4 * [info level]}] {} \
	      [file tail $d2]]
    file delete -force -- $d2
    file mkdir $d2

    foreach ftail [glob -directory $d1 -nocomplain -tails *] {
	set f [file join $d1 $ftail]
	if {[file isdirectory $f] && [string compare CVS $ftail]} {
	    copyDir $f [file join $d2 $ftail]
	} elseif {[file isfile $f]} {
	    file copy -force $f [file join $d2 $ftail]
	    if {$::tcl_platform(platform) eq {unix}} {
		file attributes [file join $d2 $ftail] -permissions 0644
	    } else {
		file attributes [file join $d2 $ftail] -readonly 1
	    }
	}
    }

    if {$::tcl_platform(platform) eq {unix}} {
	file attributes $d2 -permissions 0755
    } else {
	file attributes $d2 -readonly 1
    }
}
###
# topic: 15c41a8a701fb2afdfbd8d479d464bda
###
proc ::gort::mkvfs::pkgIndexDir {root fout d1} {
    puts [format {%*sIndexing %s} [expr {4 * [info level]}] {} \
	      [file tail $d1]]
    set idx [string length $root]
    foreach ftail [glob -directory $d1 -nocomplain -tails *] {
	set f [file join $d1 $ftail]
	if {[file isdirectory $f] && [string compare CVS $ftail]} {
	    pkgIndexDir $root $fout $f
	} elseif {[file tail $f] eq "pkgIndex.tcl"} {
	    puts $fout "set dir \${VFSROOT}[string range $d1 $idx end]"
	    puts $fout [cat $f]
	}
    }
}

proc ::gort::mkvfs::inject-tcl {PLATFORM BASE_DIR TCLSRC_ROOT} {
  set TCL_SCRIPT_DIR [file join $BASE_DIR tcl]
  file mkdir $TCL_SCRIPT_DIR
  puts "Building [file tail $TCL_SCRIPT_DIR] for $PLATFORM"
  copyDir ${TCLSRC_ROOT}/library ${TCL_SCRIPT_DIR}
  
  if {$PLATFORM == "windows"} {
      set ddedll [glob -nocomplain ${TCLSRC_ROOT}/win/tcldde*.dll]
      puts "DDE DLL $ddedll"
      if {$ddedll != {}} {
          file copy $ddedll ${TCL_SCRIPT_DIR}/dde
      }
      set regdll [glob -nocomplain ${TCLSRC_ROOT}/win/tclreg*.dll]
      puts "REG DLL $ddedll"
      if {$regdll != {}} {
          file copy $regdll ${TCL_SCRIPT_DIR}/reg
      }
  } else {
      # Remove the dde and reg package paths
      file delete -force ${TCL_SCRIPT_DIR}/dde
      file delete -force ${TCL_SCRIPT_DIR}/reg
  }
  
  # For the following packages, cat their pkgIndex files to tclIndex
  if {$::tcl_platform(platform) eq {unix}} {
      file attributes [file join ${TCL_SCRIPT_DIR} tclIndex] -permissions 0744
  } else {
      file attributes [file join ${TCL_SCRIPT_DIR} tclIndex] -readonly 0
  }
  set fout [open [file join ${TCL_SCRIPT_DIR} tclIndex] a]
  puts $fout {#
  # MANIFEST OF INCLUDED PACKAGES
  #
  set VFSROOT $dir
  }
  pkgIndexDir ${TCL_SCRIPT_DIR} $fout ${TCL_SCRIPT_DIR}
  close $fout
  exit 0
}

proc ::gort::mkvfs::inject-tk {PLATFORM BASE_DIR TKSRC_ROOT TK_FULL_VERSION TK_DLL} {
  set TCL_SCRIPT_DIR [file join $BASE_DIR tcl]
  set TK_SCRIPT_DIR [file join $BASE_DIR tk]
  file mkdir $TK_SCRIPT_DIR
  
  puts "Building [file tail $TK_SCRIPT_DIR] for $PLATFORM"
  copyDir ${TKSRC_ROOT}/library ${TK_SCRIPT_DIR}
  if { $TK_DLL eq {} } {
    exit 0
  }
  set TK_DLL [string map {' {}} $TK_DLL]
  puts "Injecting Tk DLL"
  if {$PLATFORM eq "windows"} {
    set dllsrc ${TKSRC_ROOT}/win/$TK_DLL
  } else {
    set dllsrc ${TKSRC_ROOT}/unix/$TK_DLL
  }
  puts [list CP $dllsrc $TK_SCRIPT_DIR/$TK_DLL]
  file copy -force $dllsrc $TK_SCRIPT_DIR/$TK_DLL
  set fout [open ${TCL_SCRIPT_DIR}/tclIndex a]
  puts $fout [string map [list @TKVERSION@ $TK_FULL_VERSION @TKDLL@ $TK_DLL] {
  package ifneeded Tk @TKVERSION@ [list load $::tk_library/@TKDLL@ Tk]
  }]
  close $fout
  exit 0
}

proc ::command::vfs::inject-tcl args {
  ::gort::mkvfs::inject-tcl {*}$args
}

proc ::command::vfs::inject-tk args {
  ::gort::mkvfs::inject-tk {*}$args
}

proc ::command::copy_path args {
  ::copy_path {*}$args
}

namespace eval ::command::vfs {
  namespace export *
  namespace ensemble create
}
