###
# Load teapot configuration for Gort
###


::namespace eval ::command {}
::namespace eval ::command::teapot {}

proc ::command::teapot::_init {} {
  package require teapotclient 0.2
  package require gort::settings
  set ::teapotservers [list teapot.rkeene.org teapot.activestate.com]
  ::teapotclient::setcachedir [file join $::gort(metapath) teapot]
  file mkdir [file join $::gort(metapath) teapot]

  package require gort::teapot

}

###
# topic: 02fef4ebb068151e5f337552117b7c0170e52c82
###
proc ::command::teapot::get {dir os cpu args} {
  _init
  set os  [::localtool teapot get os]
  set cpu [::localtool teapot get cpu]
  
  if {[llength $args] < 1} {
    puts stderr "Usage: teapot-get <dir> <os> <cpu> <packages...>"
    exit 1
  }
  
  set existingexts [list]
  set packages $args
  
  set newpackages [list]
  foreach package $packages {
    if {[string index $package 0] == "!"} {
            lappend existingexts [string range $package 1 end]
    } else {
            lappend newpackages $package
    }
  }
  set packages $newpackages
  
  set extsinfo [::teapotclient::download_extensions [file join $dir lib] $::teapotservers $packages $os $cpu $existingexts]
  set exts [list]
  puts "Fetched Extensions:"
  foreach {ext extinfo} $extsinfo {
    lappend exts $ext
    puts "  $ext v[lindex $extinfo 0]"
  }
  
  set failedexts [list]
  foreach pkg $packages {
    if {[lsearch -exact $exts $pkg] == -1} {
            lappend failedexts $pkg
    }
  }
  if {[llength $failedexts] != 0} {
    puts "Failed to fetch:"
    foreach ext $failedexts {
            puts "  $ext"
    }
    exit 1
  }
}

###
# topic: ed1a1f195f81531dd07d86890415366d6c3d5350
###
proc ::command::teapot::info args {
  package require gort::teapot

  set os  [::localtool teapot get os]
  set cpu [::localtool teapot get cpu]
    
  puts stdout "OS: $os"
  puts stdout "CPU: $cpu"
  puts stdout "SERVERS: $::teapotservers"
}

###
# topic: 53d1f72949ee8355ca95aed1737761c21bd0d26d
###
proc ::command::teapot::list args {
  package require gort::teapot

  set os  [::localtool teapot get os]
  set cpu [::localtool teapot get cpu]
  if {[llength $args] > 0} {
    set os [lindex $args 0]
  }
  if {[llength $args] > 1} {
    set cpu [lindex $args 1]
  }
  
  puts "Extensions available for OS=$os, CPU=$cpu:"
  
  foreach teapotserver $::teapotservers {
    array set exts [::teapotclient::get_extensions $teapotserver $os $cpu]
  }
  
  foreach ext [lsort -dictionary [array names exts]] {
    set extinfo $exts($ext)
  
    set extvers [list]
    foreach extinfoitem $extinfo {
            set extinfoitemvers [lindex $extinfoitem 0]
            if {[lsearch -exact $extvers $extinfoitemvers] == -1} {
                    lappend extvers $extinfoitemvers
            }
    }
    set extvers [lsort -decreasing -dictionary $extvers]
  
    puts "  $ext [lindex $extvers 0]"
  }
}

::shell::ensemble ::command::teapot

