namespace eval ::command::spawn {}

array set ::shell::help {
  spawn        {Tools for spawning other processes}
  {spawn tcl}  {Spawn a new tcl-based process}
  {spawn make} {Spawn a call to gnumake}
  {spawn tk}   {Spawn a new tk-based process (to explicitly call out wish)}
  {spawn diff} {Perform a TkDiff of two files}
  {spawn edit} {Spawn a graphical ASCII file editor}
}

array set ::shell::cname {
  edit {spawn edit}
  diff {spawn diff}
  sqlite {spawn sqlite}
  fork {spawn fork}
  tclmake {spawn smake}
  smake {spawn smake}
}

proc ::command::spawn::tcl args {
  return [exec $::gort(tclsh) {*}$args &]
}

proc ::command::spawn::tk args {
  return [exec $::gort(tclsh) {*}$args &]
}

proc ::command::spawn::diff args {
  return [exec {*}$::gort(exec) diff {*}$args &]
}

proc ::command::spawn::edit args {
  return [exec {*}$::gort(exec) edit {*}$args &]
}

proc ::command::spawn::sqlite args {
  return [exec {*}$::gort(exec) sqlite {*}$args &]
}

proc ::command::spawn::fork args {
  return [exec {*}$::gort(exec) {*}$args &]
}

proc ::command::spawn::smake args {
  return [doexec {*}$::gort(exec) smake {*}$args]
}

namespace eval ::command::spawn {
  namespace export *
  namespace ensemble create
}