::namespace eval ::command {}
::namespace eval ::command::shed {}

proc ::command::shed::schema {} {
  package require shed
  ::shed::schema
}

proc ::command::shed::import {filename} {
  package require shed::db
  ::shed::import $filename
}

proc ::command::shed::regenerate {} {
  package require shed::db
  ###
  # Load all known sheds into a central library
  ###
  set list [::command::project::List]
  foreach {file} $list {
    ::command::project::shed [file dirname $file]
    ::shed::import $file
  }
}

proc ::command::shed::List args {
  package require shed::db
  if {[llength $args]==0} {
    return [join [lsort -dictionary [::shed::db eval {select distinct shed_class from entity}]] \n]
  }
  set pattern [lindex $args 0]
  set reply {}
  ::shed::db eval {select * from entity where shed_class=:pattern} {
    append reply [list $uuid $name $version] \n
  }
  return $reply
}

proc ::command::shed::info {class {name {}}} {
  package require shed::db
  set stmt {}
  
  if {$name eq {}} {
    set stmt {select * from entity where (name=:class or uuid=:class)}
  } else {
    set stmt {select * from entity where (uuid=:class) OR (shed_class=:class and name=:name) OR (shed_class=:class AND uuid=:name);}
  }
  set result {}
  ::shed::db eval $stmt {
    dict set result $uuid name: $name
    dict set result $uuid version: [string trim $version]
    dict set result $uuid shed_class: $shed_class

    ::shed::db eval {select * from meta where entity=:uuid} {
      dict set result $uuid $field: $value
    }
    set links {}
    ::shed::db eval {select * from link where fromid=:uuid} {
      dict lappend links $linktype $toid
    }
    ::shed::db eval {select * from entity where uuid in (select fromid from link where toid=:uuid)} other {
      dict set result $uuid $other(shed_class): [list $other(uuid) ($other(name))]
    }
    set links {}
    ::shed::db eval {select * from entity where uuid in (select toid from link where fromid=:uuid)} other {
      #dict lappend links $linktype/ [list name $other(name) shed_class $other(shed_class) uuid $other(uuid) ]
      dict lappend links $linktype/ $other(uuid)

      #dict set result $uuid $other(shed_class) name $other(name)
      #dict set result $uuid $other(shed_class) uuid $other(uuid)
    }
    foreach {linktype linkinfo} $links {
      dict set result $uuid $linktype $linkinfo 
    }
  }
  return [dict print $result]
}

proc ::command::shed::search args {
  if {[llength $args]==0} {
    error "Usage: package search ?name?
OR
package search FIELD VALUE ?FIELD VALUE...? "
  }
  package require shed::db
  if {[llength $args]==1} {
    set pattern [lindex $args 0]
    set dat {}
    ::shed::db eval {select * from entity} {
      #puts [list $uuid $name $shed_class]
      if {[string match -nocase $pattern $name]} {
        append dat [list $uuid $shed_class $name $version] \n
      }
    }
    return $dat
  }
  if {[llength $args]==2} {
    set class [lindex $args 0]
    set pattern [lindex $args 1]
    set dat {}
    ::shed::db eval {select * from entity where shed_class=:class} {
      #puts [list $uuid $name $shed_class]
      if {[string match -nocase $pattern $name]} {
        append dat [list $uuid $shed_class $name $version] \n
      }
    }
    return $dat
  }
}



::shell::ensemble ::command::shed
::shell::alias {shed list} ::command::shed::List