::namespace eval ::command {}
::namespace eval ::command::recipe {}

::shell::alias  get-source      {recipe::fetch}
::shell::alias  fetch           {recipe::fetch} 
::shell::alias  install         {recipe::install}
::shell::alias  list            {recipe::list}
::shell::alias  reinstall       {recipe::reinstall}
::shell::alias  uninstall       {recipe::uninstall}
::shell::alias  update          {recipe::upgrade}
::shell::alias  upgrade         {recipe::upgrade}
::shell::alias  package-fetch   {recipe::fetch}
::shell::alias  pkg_mkIndex     {module_index}

###
# topic: 5d852f92df5baf7db6aed375cb1095193bd16e0e
###
proc ::command::recipe::do {module method args} {
  ::package require gort::recipes
  if {$method eq "index"} {
    module_index {*}$args
    return
  }
  puts "DO $module $method $args"
  #if {[info exists ::recipe_group($module)]} {
  #  foreach rec $::recipe_group($module) {
  #    set obj [::gort::recipe_object $rec]
  #    lappend ans [$obj $method {*}$args]
  #  }    
  #} else {
    set obj [::gort::recipe_object $module]
    set ans [$obj $method {*}$args]
  #}
  return $ans
}

###
# topic: 4ce5e9bc76501564a2635eff8c3e76350680ad26
# title: Install a recipe to the local file system
###
proc ::command::recipe::build args {
  ::package require gort::recipes

  global modules odie
  foreach mod $args {
    ::command::recipe::do $mod recipe-build
    update
  }    
}

###
# topic: 686a47d2b9e91d20bd3803becca9e327b5a99c7b
# title: Fetch the source for a recipe
###
proc ::command::recipe::fetch args {
  ::package require gort::recipes

  global modules odie
  foreach mod $args {
    set object [::gort::recipe_object $mod]
    if {[::command::recipe::do $mod  recipe-present]} continue
    if {[::command::recipe::do $mod  recipe-skip]} continue
    if {$mod ni {tcl tk}} {
      set path [::command::recipe::do $mod  path-module]
      ::command::recipe::do $mod <distribution> download
      ::command::recipe::do $mod recipe-detect-properties 1
      update
    }
  } 
}

###
# topic: 4ce5e9bc76501564a2635eff8c3e76350680ad26
# title: Install a recipe to the local file system
###
proc ::command::recipe::install args {
  ::package require gort::recipes

  global modules odie
  foreach mod $args {
    if {[::command::recipe::do $mod recipe-present]} continue
    ::command::recipe::do $mod recipe-build
    ::command::recipe::do $mod recipe-install
    update
  }    
}

###
# topic: e04ae47cd09a27b0cd26a2f9d6e783dc8723f9a4
# title: List recipes known by gort
###
proc ::command::recipe::list {} {
  ::package require gort::recipes

  global recipe
  set result {}
  foreach mod [array names ::recipe] {
    if {[catch {::command::recipe::do $mod recipe-skip} skip]} {
      set skip 0
    }
    if {$skip} continue
    lappend result $mod
  }
  return [lsort -dictionary $result] 
}

###
# topic: 3959b1b030d6f8db6a87d09dc294ab50295e30bb
# title: Uninstall and reinstall a recipe locally
###
proc ::command::recipe::reinstall args {
  ::package require gort::recipes

  foreach mod $args {
    if {$mod in {tcl tk sqlite}} continue
    ::command::recipe::do $mod recipe-uninstall
  }
  foreach mod $args {
    if {[::command::recipe::do $mod recipe-skip]} continue
    ::command::recipe::do $mod recipe-install
  }
}

###
# topic: d3c21044d57d1e2b5e0a79047a761a69e5d9a4dd
###
proc ::command::recipe::requirements args {
  ::package require gort::recipes

  set result {}
  foreach mod $args {
    logicset add result {*}[::command::recipe::do $mod recipe_requires]
  }
  return $result
}

###
# topic: 7cd11e08c51b39a1c2f2ef6bb222af4ae356721d
# title: Uninstall a recipe locally
###
proc ::command::recipe::uninstall args {
  ::package require gort::recipes

  foreach mod $args {
    ::command::recipe::do $mod recipe-uninstall
  }  
}

###
# topic: 2128bf65696129569019f74118d8ed5388746954
# title: Upgrade a local recipe
###
proc ::command::recipe::upgrade args {
  ::package require gort::recipes
  if {"all" in $args } {
    set modulelist [array names ::recipe]
  } else {
    set modulelist $args 
  }
  foreach mod $modulelist {
    ::command::recipe::do $mod recipe-upgrade
  }
}

::shell::ensemble ::command::recipe
