::namespace eval ::command {}
::namespace eval ::command::project {}

proc ::command::project::List args {
  package require shed
  set result {}
  foreach directory [glob -nocomplain [file join $::gort(sandbox) *]] {
    if {[file exists [file join $directory project.shed]]} {
      lappend result [file join $directory project.shed]
    }
  }
  return [join $result \n]
}

proc ::command::project::shed {args} {
  package require shed
  package require gort::settings
  set filename [lindex $args 0]
  if {[lindex $args 0] eq {}} {
    set ::TOOL_ROOT [pwd]
  } else {
    set ::TOOL_ROOT [lindex $args 0]
  }
  set cwd [pwd]
  cd $::TOOL_ROOT
  
  set scriptfile [lindex $args 1]
  if {$scriptfile eq {}} {
    foreach path {shed.tcl support/shed.tcl scripts/shed.tcl} {
      if {[file exists [file join $::TOOL_ROOT $path]]} {
        set scriptfile [file join $::TOOL_ROOT $path]
        break            
      }
    }
  }
  catch {rename ::project {}}
  set shed [::command::project::Info $::TOOL_ROOT]
  ###
  # Seed the UUID system with the UUID of the project
  ###
  set ::uuid::machinfo [dict get $shed uuid:]
  set ::uuid::uuid 1

  ::shed::document create ::project $shed
  set project [::project add [dict merge $shed {shed_class: project}]]
  if {[file exists $scriptfile]} {
    puts "RUNNING $scriptfile"
    $project shed source $scriptfile
  } else {
    puts "AUTOSCAN"
    $project autoscan $::TOOL_ROOT     
  }
  set projuuid [$project shed uuid]
  $project <db> eval {select uuid from entity where shed_class='package'} {
    $project <db> eval "insert or ignore into link (fromid,toid,linktype) VALUES (:projuuid,:uuid,'package');"
  }
  set output [dict print [::project export]]
  ::project destroy
  set fout [open [file join $::TOOL_ROOT project.shed] w]
  puts $fout  $output
  close $fout
  cd $cwd
}

proc ::command::project::Info path {
  # If we are inside a fossil repository
  # use that
  set shed {}
  dict set shed generated: [clock format [clock seconds] -gmt 1]
  dict set shed name: [file dirname $path]
  dict set shed class: project
  set srcpath $path

  if {$::gort(fossil) ne {}} {
    if {[file exists [file join $srcpath .fslckout]] || [file exists [file join $srcpath _FOSSIL_]]} {
      return [_FossilInfo $path]
    }
  }
  dict set shed uuid: [::uuid::uuid generate]
  return $shed
}

proc ::command::project::_FossilInfo srcpath {
  set cwd [pwd]
  cd $srcpath

  set repoinfo {shed_class: distribution format: fossil}
  set releaseinfo {}
  set fosinfo [exec $::gort(fossil) info]
  foreach line [split $fosinfo \n] {
    if {![info complete $line]} continue
    if {[catch {lindex $line 0} keyword]} continue
    switch $keyword {
      project-code: {
        set uuid [lindex $line 1]
        dict set repoinfo project: [lindex $line 1]
      }
      checkout: {
        #dict set repoinfo checkout: [lindex $line 1]
        dict set releaseinfo timestamp: [lrange $line 2 end]
        dict set shed generated: [lrange $line 2 end]
      }
      leaf: {
        dict set releaseinfo [lindex $line 0] [lindex $line 1]
      }
      tags: {
        dict set repoinfo release: [string trimright [lindex $line 1] ,]
        dict set shed release: [string trimright [lindex $line 1] ,]
      }
      project-name: {
        dict set repoinfo [lindex $line 0] [lrange $line 1 end]
      }
    }
  }
  
  set remote [exec $::gort(fossil) remote-url]
  set remotel [split $remote /]
  set serverl [split [lindex $remotel 2] @]
  if {[llength $serverl]==2} {
    set server [lindex $serverl 1]
  } else {
    set server [lindex $remotel 1]
  }
  dict set repoinfo url: [lindex $remotel 0]//$server/[join [lrange $remotel 3 end] /]

  ###
  # Build a distribution
  ###
  exec $::gort(fossil) configuration export project FOSOUT
  set fin [open FOSOUT r]
  set thisline {}
  while {[gets $fin line] >= 0} {
    append thisline $line \n
    if {![info complete $thisline]} continue
    if {[lindex $thisline 1] eq {'project-description'}} {
      dict set shed description: [string range $thisline 40 end-2]
    }
    if {[lindex $thisline 1] eq {'short-project-name'}} {
      dict set repoinfo project-short-name: [string range $thisline 39 end-2]
      dict set shed name: [string range $thisline 39 end-2]
    }
    set thisline {}
  }
  close $fin
  file delete FOSOUT        
  if {![dict exists $shed name:]} {
    dict set shed name: [file tail $::TOOL_ROOT]
  }
  set tag [lindex [dict get $repoinfo release:] 0]
  set releaseinfo [list shed_class: release name: $tag checkout: $tag timestamp: [dict get $shed generated:]]
  set distinfo [dict merge $repoinfo [list project: $uuid name: fossil]]
  dict set shed release: $tag
  dict set shed distribution: fossil
  dict lappend shed release/ $releaseinfo
  dict lappend shed distribution/ $distinfo 
  dict set shed uuid: $uuid

  cd $cwd
  return $shed
}

proc ::command::project::use {args} {
  package require shed
  set filename [lindex $args 0]
  if {[lindex $args 0] eq {}} {
    set ::TOOL_ROOT [pwd]
  } else {
    set ::TOOL_ROOT [lindex $args 0]
  }
  if {[file exists [file join $::TOOL_ROOT project.shed]]} {
    catch {rename ::tool {}}
    ::shed::class::project create ::tool [fileutil::cat [file join $::TOOL_ROOT project.shed]]
  } else {
    ::command::project::shed
  }
}

::shell::ensemble ::command::project
