
proc ::command::help args {
  set proglist {}
  foreach item [lsort -dictionary [info commands ::command::*]] {
    set cmdname [namespace tail $item]
    if {[string index $cmdname 0] eq "_"} continue
    lappend proglist $cmdname
  }
  if {$args eq {}} {
    return $proglist
  }
  variable help
  set result {}
  if {[info exists help($args)]} {
    append result $help($args)
  }
  set command ::command::[join $args ::]
  if {[info command $command] ne {}} {
    try {
      info args $command
    } on ok {} {
      if {$result ne {}} {
        append result \n
      }
      append result "Usage: $args [info args $command]"
    } on error {} {
      # Do nothing
    }
  }
  # Look for an ensemble
  foreach subcmd [lsort -dictionary [info command ${command}::*]] {
    if {$result ne {}} {
      append result \n
    }
    append result "Subtopic: [namespace tail $subcmd]"
  }
  if {$result ne {}} {
    return $result
  }
  return [_shrug]
}

proc ::command::_shrug {} {
  return [encoding convertfrom unicode [binary decode hex af005c005f002800c43029005f002f00af00]]
}