shell::help fossil {Wrapper around the fossil-scm executable}

proc ::command::fossil {method args} {
  package require gort::settings

  switch $method {
    sqlite {
      error "$method is unsupported"
    }
    server -
    ui {
      # Launch these process in the background
      exec $::gort(fossil) $method {*}$args &      
    }
    move {
      package require fileutil
      #catch {exec make -C $src clean}
      set dest [lindex $args end]
      foreach src [lrange $args 0 end-1] {
        foreach file [::fileutil::findByPattern $src -glob *] {
          set nearpath [::fileutil::stripPwd $file]
          set subpath [::fileutil::relativeUrl $src $file]
          set newpath [file join $dest {*}[lrange [file split $subpath] 1 end]]
          if {[file isdirectory $file]} {
            file mkdir [file dirname $newpath]
          } else {
            puts [list $nearpath -> $newpath]
            file mkdir [file dirname $newpath]
            file rename $file $newpath
            ::shell::doexec $::gort(fossil) mv $nearpath $newpath
          }
        }
      }
    }
    scmcopy {
      
    }
    commit {
      set textfile [::shell::text]
      if {![file exists $textfile]} return
      if {[file size $textfile]==0} return
      ::shell::doexec $::gort(fossil) $method --no-warnings -M $textfile {*}$args      
    }
    default {
      ::shell::doexec $::gort(fossil) $method {*}$args
    }
  }
}



###
# topic: 0064c4d01884c20a5c4e06bcba9c173cb1bed63a
###
proc ::command::scm_copy args {
  package require gort::settings
  package require codebale::scm
  package require sqlite3
  set ::scmroot [pwd]
  if {[file exists [file join $::scmroot _FOSSIL_]]} {
    sqlite3 ::repodb [file join $::scmroot _FOSSIL_] 
    set ::fosdbfile [repodb one {select value from vvar where name='repository'}]
    sqlite3 ::fosdb [file join $::scmroot ${::fosdbfile}] 
  } elseif {[file exists [file join $::scmroot .fslckout]]} {
    sqlite3 ::repodb [file join $::scmroot .fslckout] 
    set ::fosdbfile [repodb one {select value from vvar where name='repository'}]
    sqlite3 ::fosdb [file join $::scmroot ${::fosdbfile}]
  } else {
    error "Cannot locate fossil checkout information in $::scmroot"
  }
  set copyright "###
  # ALL CODE, UNLESS OTHERWISE MARKED, IS COPYRIGHT [clock format [clock seconds] -format "%Y"]
  ###"
  
  if { $args == {} } {
      puts "Usage: [file tail [info script]] source ?source...? destination_path"
      exit 1
  }
  
  if {[set pos [lsearch $args -makeManifest]] >= 0} {
    set State(makeManifest) 1
    set p1 $pos
    incr p1
    set State(manifest) [lindex $args $p1]
    set argv [lreplace $args $pos $p1]
  } else {
    set State(makeManifest) 1
    set State(manifest) manifest.txt
  }
  
  set dest [lindex $args end]
  foreach src [lrange $args 0 end-1] {
      if { [string first * $src] >= 0 } {
          lappend stack $src $dest
      } elseif { [file isdirectory $src] } {
          lappend stack "${src}/*" $dest
      } else {
          lappend stack $src $dest
      }
  }
  
  if {$State(makeManifest)} {
    if {[file exists $State(manifest)]} {
      set exist 1
    } else {
      set exist 0
    }
  
    if {$exist} {
      set State(of) [open $State(manifest) a]
    } else {
      set State(of) [open $State(manifest) w]
      puts $State(of) $copyright
      puts $State(of) "package provide manifest 1.0"
    }
  }
  
  while {[llength $stack] > 1} {
      set src [file normalize [lindex $stack 0]]
      #set dest [file normalize [lindex $stack 1]]
      set dest [lindex $stack 1]
      set stack [lrange $stack 2 end]
      
      if { [string first * $src] >= 0 } {
          foreach file [glob -nocomplain $src] {
              lappend stack $file $dest
              incr files
          }
          continue
      }
      if [file isdirectory $src] {
          foreach file [glob -nocomplain $src/*] {
              lappend stack $file [file join $dest [file tail $src]]
          }
          continue
      }
      if [file isfile $src] {
          copy $src $dest
      }
  }
}
