###
# Utility commands for enhancing the gort shell:
###

namespace eval ::shell {}
namespace eval ::shell::coroutine {}

namespace eval ::command::shell {}

proc ::shell::ensemble {nspace {aliases {}}} {
  namespace eval $nspace {
    namespace export *
    namespace forget _*
    namespace ensemble create
  }
  if {[llength $aliases]} {
    set map [namespace ensemble configure $nspace -map]
    foreach {local alias} $aliases {
      dict set map $local $nspace $local $alias   
    }
    namespace ensemble configure $nspace -map $map
  }
}

proc ::shell::alias {command args} {
  set ::shell::cname($command) $args
}
proc ::shell::help {command text} {
  set ::shell::help($command) $text
}
proc ::shell::coroutine {name script} {
  set ::shell::coroutine($name) $script
}

proc ::shell::doexec args {
  exec {*}$args >&@ stdout
}

proc ::shell::echo chan {
  puts stdout [::chan read $chan]
  set ::shell::trace($chan) 1
}

proc ::shell::text {} {
  set filename [fileutil::tempfile]
  set cmd [list {*}$::gort(exec) edit $filename]
  exec {*}$cmd
  return $filename
}

::shell::help {shell alias} {Create an alias to a command in the gort shell}
proc ::command::shell::alias {command args} {
  set ::shell::cname($command) $args
}
::shell::alias alias {shell alias}

::shell::ensemble ::command::shell

proc ::doexec args {
  exec {*}$args >&@ stdout
}

