::namespace eval ::command {}

###
# topic: 63cd844d7201ef507ce988c9ed10f6177477f574
###
proc ::command::_isnew name {
  return [string match *.tcl.new $name]
}


###
# topic: 4a85047b41c3b611088bed04b2a323ca4dd7e163
# title: Perform an autodoc scan of a directory
###
proc ::command::autodoc {method args} {
  switch $method {
    project {
      # title: Perform an autodetection of package info
      set info [::codebale::project_detect [pwd]]
      foreach {field value} [lsort -stride 2 -dictionary $info] {
        puts "$field $value"
      }
    }
    changes {
      # title: Walk through and approve/deny suggested changes
      package require odie::processman
      puts "CHANGES"
      package require fileutil
      package require Tk
      set tclsh [info nameofexecutable]
      set project [::codebale::project_detect [pwd]]
    
      if {[winfo children .] eq {}} {
        set w {}
      } else {
        set w .autodoc
        toplevel $w
      }
      set list [::fileutil::find [dict get $project local-root:] _isnew]
    
      button $w.keep -text "Keep Change" -command {set action keep}
      button $w.trash -text "Trash Change" -command {set action trash}
      button $w.skip -text "Skip" -command {set action skip}
      grid $w.keep $w.trash $w.skip
    
      foreach item $list {
        set oldfile [file rootname $item]
        set newfile $item
        if [catch {::command::spawn::diff [file rootname $item] $item} pid] {
          puts $pid
          exit
        }
        vwait action
        ::processman::kill diff
        switch $::action {
          keep {
            file rename -force $newfile $oldfile
          }
          trash {
            file delete $newfile
          }
          skip {}
        }
      }
    }
    diagram {
      # title: Generate a graphvis visualation of the framework in the directory
      package require tao-sqlite
      set project [::codebale::project_detect [pwd]]
      
      set docbase [file join [dict get $project local-root:] autodoc]
      file mkdir $docbase
      set dbfile [file join $docbase taodb.sqlite]
      if {![file exists $dbfile]} {
        foreach module [dict get $project modules:] {
          set mpath [file join [dict get $project local-root:] modules $module]
          if {[file exists $mpath/index.tcl]} {
            if [catch {uplevel #0 [list source $mpath/index.tcl]} err] {
              puts "Error reading $mpath:\n$err"
            }
          }
        }
        ::tao::db backup $dbfile
      } else {
        namespace eval ::tao {}
        package require sqlite3
        sqlite3 ::tao::db $dbfile
      }
      
      ::tao::diagram all [file join $docbase classes.gv]
      foreach module [::tao::db eval {select distinct package from class}] {
        ::tao::diagram $module [file join $docbase module_$module.gv]
      }
    }
    scan {
      set project [::codebale::project_detect [pwd]]
      ::codebale::autodoc [list rewrite 0 {*}${project}] {*}$args
    }
    rewrite {
      puts REWRITE
      set project [::codebale::project_detect [pwd]]
      ::codebale::autodoc [list rewrite 1 {*}${project}] {*}$args
    }
  }
}


array set ::shell::help {
  autodoc {Perform an autodoc scan of a directory}
  {autodoc changes} {Walk through and approve/deny suggested changes}
  {autodoc diagram} {Generate a graphvis visualation of the framework in the directory}
}

