###
# Install SQLITE if not present
###
set path [file normalize [file join [file dirname [file normalize [info script]]] ..]]

set ::auto_path [linsert $::auto_path 0 [file join $path modules]]
package require gort::settings
set ::auto_path [linsert $::auto_path 0 [file join $::gort(prefix) lib]]
proc ::noop args {}
namespace eval ::shell {}


proc ::doexec args {
  exec {*}$args >&@ stdout
}
parray gort
set sqlite {
  aliases tclsqlite
  package_name sqlite
  package_version 3.9.2
  package_binary 1
  package_binary_tk 0
  snapshot_dir sqlite-autoconf-3090200
  snapshot_url {http://www.sqlite.org/2015/sqlite-autoconf-3090200.tar.gz}
  toolset tea
  distribution snapshot
}
set source_dir [file join $::gort(sandbox) sqlite tea]
file mkdir [file join $::gort(download) source]
if {![file exists $source_dir]} {
  dict with sqlite {}
  foreach shapshot_file [list \
    [file join $::gort(download) $snapshot_dir.tar.gz] \
    [file join $::gort(download) source $snapshot_dir.tar.gz] \
  ] {
    if {[file exists $shapshot_file]} break
  }
  if {![file exists $shapshot_file]} {
    package require http::wget
    ::http::wget $snapshot_url $shapshot_file
  }
  source [file join $::SRCDIR command archive.tcl]
  ::command::archive::untar $shapshot_file $source_dir
}
set work_dir [file join $::gort(sandbox) build local sqlite]
if {[file exists work_dir]} {
  file delete -force $work_dir
}
file mkdir $work_dir
cd $work_dir
doexec sh [file join $source_dir configure] --prefix=$::gort(prefix) --libdir=[file join $::gort(prefix) lib]
doexec make install
