set path [file normalize [file join [file dirname [file normalize [info script]]] ..]]

set ::auto_path [linsert $::auto_path 0 [file join $path modules]]
package require gort::settings
set ::auto_path [linsert $::auto_path 0 [file join $::gort(prefix) lib]]
proc ::noop args {}

namespace eval ::gort_bootstrap {}

proc ::gort_bootstrap::download_fossil {pkg} {
  variable distribution
  set PKG_SRCPATH [sandbox_path $pkg]
  set fosdb [fossil_db $pkg]
  if {![file exists $fosdb]} {
    puts "Fossil clone $pkg"
    set fossil_url {}
    if {[dict exists $distribution $pkg fossil_url]} {
      set fossil_url [dict get $distribution $pkg fossil_url]
    }
    if {$fossil_url eq {}} {
      set fossil_url $::gort(mirror_url)/$pkg
    }
    doexec $::gort(fossil) clone $fossil_url $fosdb
  }

  if {![file exists ${PKG_SRCPATH}/[::localtool platform get fossil_checkout]]} {
    puts "Fossil open $pkg"
    file mkdir ${PKG_SRCPATH}
    cd ${PKG_SRCPATH}
    doexec $::gort(fossil) open $fosdb
  }
  cd ${PKG_SRCPATH}
  if {[dict exists $distribution $pkg fossil_branch]} {
      doexec $::gort(fossil) update [dict get $distribution $pkg fossil_branch]
  } else {
      doexec $::gort(fossil) update
  }
  return ${PKG_SRCPATH}
}



proc ::gort_bootstrap::sandbox_path pkg {
  return [file join $::gort(sandbox) $pkg]
}

proc ::gort_bootstrap::build_gnumake {pkg action} {
  puts "BUILD GNUMAKE $pkg $action"
  if {$action eq "install"} {
    set PKG_SRCPATH [sandbox_path $pkg]
    cd ${PKG_SRCPATH}
    doexec $::gort(fossil) update
    set args [list  --prefix=$::gort(prefix)]
    lappend args  --libdir=$::gort(prefix)/lib
    doexec sh ./configure {*}$args
    if [catch {
        domake install
    } err] {
	puts "Died on $err"
	exit 1
    }
  } else {
    set PKG_SRCPATH [sandbox_path $pkg]
    cd ${PKG_SRCPATH}
    if [catch {
        domake $action
    } err] {
	puts "Died on $err"
	exit 1
    }
  }
}

proc ::gort_bootstrap::build_sak {pkg action} {
  if {$action eq "install"} {
    set PKG_SRCPATH [sandbox_path $pkg]
    doexec $::gort(tclsh) [file join $PKG_SRCPATH installer.tcl] \
		-app-path $::gort(prefix)/bin -pkg-path $::gort(prefix)/lib/$pkg \
                -no-examples -no-nroff -no-html \
                -no-wait -no-gui
  }
}

proc ::gort_bootstrap::build_kettle {pkg action} {
  set PKG_SRCPATH [sandbox_path $pkg]
  if {$pkg eq "kettle"} {
    doexec $::gort(tclsh) [file join $PKG_SRCPATH kettle] -f [file join $PKG_SRCPATH build.tcl] $action
  } else {
    doexec $::gort(tclsh) $::gort(kettle) -f [file join $PKG_SRCPATH build.tcl] $action
  }
}

proc ::gort_bootstrap::install_package package {
  variable distribution
  set pkginfo [dict get $distribution $package]
  puts [list $package $pkginfo]
  set download [dict get $pkginfo get_proc]
  $download $package
  set build    [dict get $pkginfo build_proc]
  $build $package install
}

proc ::gort_bootstrap::distribution {name properties} {
  variable distribution
  foreach {field value} $properties {
    
    dict set distribution $name $field $value
  }
  if {![dict exists $distribution $name get_proc]} {
    dict set distribution $name get_proc ::noop
  }
  if {![dict exists $distribution $name build_proc]} {
    dict set distribution $name build_proc ::noop
  }
}

::gort_bootstrap::distribution taolib {
  get_proc   download_fossil
  requires {sqlite tcllib tklib}
  build_proc build_sak
}
::gort_bootstrap::distribution tcllib {
  get_proc   download_fossil
  fossil_branch odie
  build_proc build_sak
}
::gort_bootstrap::distribution tklib {
  get_proc   download_fossil
  requires tcllib
  build_proc build_sak
}

###
# Make sure the odielib toolkit is downloaded
###
if {![file exists [file join $::gort(sandbox) odielib modules odie index.tcl]]} {
  ::gort_bootstrap::download_fossil odielib
}
set auto_path [linsert $auto_path 0 [file join $path modules]]
package require fileutil
package require codebale

