###
# Ensure Tcllib and Taolib are available locally from source
###
source [file join $::gort(modules) dicttool dicttool.tcl]
source [file join $::gort(modules) gort utils.tcl]
source [file join $::gort(modules) gort setup.tcl]

proc build_path pkg {
  return [file join $::gort(sandbox) build local $pkg]
}


proc ::doexec args {
  puts "EXEC $args"
  exec {*}$args >&@ stdout
}

###
# Use our own local packages before going to the environment
###
set ::auto_path [linsert $::auto_path 0 [file join $::gort(prefix) lib]]

foreach {project branch url libfolder} {
  tcllib odie   tcllib modules
  taolib trunk  taolib modules
  critcl gort   critcl lib
} {
  set path [::gort::project_source $project exists]
  if {!$exists} {
    puts "RETRIEVING $project"
    set cwd [pwd]
    file mkdir $path
    cd $path
    set fosdb [::gort::fossil_db $project]
    if {![file exists $fosdb]} {
      if {[catch {
        doexec $::gort(fossil) clone $::gort(mirror_url)/$url $fosdb
      }]} {
        doexec $::gort(fossil) clone http://fossil.etoyoc.com/fossil/$url $fosdb        
      } 
    }
    
    doexec $::gort(fossil) open $fosdb $branch
  } else {

  }
  set ::auto_path [linsert $::auto_path 0 [file join $path $libfolder]]
}
set install_sqlite 0

if {[lrange $argv 0 1] eq "install sqlite"} {
  set install_sqlite 1
}
if {[lrange $argv 0 2] eq "recipe install sqlite"} {
  set install_sqlite 1
}
if {!$install_sqlite && [catch {package require sqlite3} err]} {
  set install_sqlite 1
}
if {$install_sqlite} {
  # Provide Sqlite
  source $::SRCDIR/../scripts/install_sqlite.tcl
}
  
