###
# Downloads, configures, and compiles Tcl
###
gort::recipe_define zip {
  active 1
  snapshot_url http://prdownloads.sourceforge.net/infozip/zip30.tar.gz
  #snapshot_url http://downloads.sourceforge.net/project/infozip/Zip%203.x%20%28latest%29/3.0/zip30.tar.gz
  snapshot_dir zip30
  package_name zip
  package_version 30
  compile_after {}
  toolset autoconf
  distribution sourceforge
} {

  method recipe-build {} {
    if {[my build_done]} {
      return
    }
    set hpath [my path-build]
    cd $hpath
    my <distribution> download [my path-module]
    my <toolset> configure $hpath/unix {*}[my meta cget configure_flags]
    my <toolset> make -f unix/Makefile generic_gcc
    my <toolset> make
  }
  
  method build_done {} {
    #if {[file exists /usr/bin/zip]} {
    #  return 1
    #}
    set lpath ${::odie(local_repo)}
    if {[file exists $lpath/bin/zip]} {
      return 1
    }
    if {[file exists $lpath/bin/zip.exe]} {
      return 1
    }
    return 0
  }
}