gort::recipe_define tcl {
  type tclpkg
  package_name Tcl
  package_version 8.6.4
  fossil_url http://fossil.etoyoc.com/fossil/tcl
  fossil_tag release
  distribution fossil
  toolset autoconf
} {
  mixin ::gort::recipe.shellpkg
  
  method package_requires {} {
    return {}
  }
  
  method path-source {} {
    return [file join [my path-module] [my <toolset> tcl get platform_source_dir]]
  }

  method gort_vfs_install path {}

  method build-options {} {
    set opts [my <toolset> tcl get config_flags]
    if {$::gort(static)} {
      lappend opts --enable-shared=no
    }
    return $opts
  }
}

gort::recipe_define tk {
  type tclpkg
  package_name Tk 
  package_version 8.6.4
  fossil_tag release
  fossil_url http://fossil.etoyoc.com/fossil/tk
  distribution fossil
  toolset autoconf
} {
  mixin ::gort::recipe.shellpkg
  
  method path-source {} {
    return [file join [my path-module] [my <toolset> tk get platform_source_dir]]
  }
  method gort_vfs_install path {}

  method package_requires {} {
    return tcl
  }
  
  method build-options {} {
    set opts [my <toolset> tk get config_flags]
    lappend opts "--with-tcl=[[::gort::recipe_object tcl] path-build]"
    if {$::gort(static)} {
      lappend opts --enable-shared=no
    }
    return $opts
  }
}

