###
# Critcl/Kettle Related Packages
###
gort::recipe_define critcl {
  toolset kettle
  git_branch trunk
  git_url http://github.com/andreas-kupries/critcl
  fossil_branch trunk
  fossil_url http://fossil.etoyoc.com/fossil/critcl
  package_name critcl
  package_binary 1
  package_binary_tk 0
  package_version 3.1.11
  distribution git
} {
  method recipe-build {} {
  }
  
  method recipe-install {} {
    cd [my path-source]
    puts [list *** INSTALL [pwd] ***]
    doexec $::gort(tclsh) build.tcl install [my define get libdir] 
  }
}

gort::recipe_define tcl-linenoise {
  git_branch trunk
  git_url http://github.com/andreas-kupries/tcl-linenoise
  fossil_branch trunk
  fossil_url http://fossil.etoyoc.com/fossil/tcl-linenoise
  package_name linenoise
  package_binary 1
  package_binary_tk 0
  requires critcl
  package_requires {critcl kettle}
  kettle_new_argstyle 1
  distrbution fossil
  toolset kettle
} {}


gort::recipe_define kettle {
  fossil_url {http://fossil.etoyoc.com/fossil/kettle}
  distribution fossil
  toolkit kettle
} {  

  method recipe-install {} {
    set kpath [my path-build]
    set opts [list --prefix [::toolset define-get prefix]]
    my kettle reinstall {*}$opts
  }
}

gort::recipe_define cmdr {
  git_branch trunk
  git_url http://github.com/andreas-kupries/cmdr
  fossil_branch trunk
  fossil_url http://fossil.etoyoc.com/fossil/cmdr
  package_name cmdr
  package_binary 1
  package_binary_tk 0
  requires {tcl-linenoise}
  package_requires {tcl-linenoise}
  distribution fossil
  toolset kettle
} {}

gort::recipe_define fx {
  git_branch trunk
  git_url http://github.com/andreas-kupries/fx
  fossil_branch trunk
  fossil_url http://fossil.etoyoc.com/fossil/fx
  package_name fx
  package_binary 1
  package_binary_tk 0
  requires {kettle cmdr fossil ssl linenoise-utilities tcl-linenoise}
  package_requires {kettle cmdr fossil}
  distribution fossil
  toolset kettle
} {}


gort::recipe_define linenoise-utilities {
  git_branch trunk
  git_url http://github.com/andreas-kupries/linenoise-utilities
  fossil_branch trunk
  fossil_url http://fossil.etoyoc.com/fossil/linenoise-utilities
  package_name linenoise-utilities
  package_binary 1
  package_binary_tk 0
  requires {kettle linenoise}
  package_requires {kettle linenoise}
  distribution fossil
  toolset kettle
} {}
