###
# Packages which simply unpack into the sandbox
###
::gort::recipe_define tclconfig {
    module tclconfig
    fossil_url {http://fossil.etoyoc.com/fossil/tclconfig}
    distribution fossil
} {  
  method recipe-build {} {
    if {[my recipe-present]} {return 1}
    if {[my recipe-skip]} {return 1}
    my <distribution> download [my path-module]
  }
}
  
###
# Really simple modules that are tea based an distributed as fossil clones
###

foreach {mod props} {
  thread        {package_binary 1 package_binary_tk 0}
  tclx          {package_binary 1 package_binary_tk 0}
  tls           {package_binary 1 package_binary_tk 0}
  tdbc          {package_binary 1 package_binary_tk 0}
  tdbcmysql     {compile_after tdbc package_binary 1 package_binary_tk 0}
  tdbcodbc      {compile_after tdbc package_binary 1 package_binary_tk 0}
  tdbcpostgres  {compile_after tdbc package_binary 1 package_binary_tk 0}
  tdbcsqlite    {compile_after tdbc package_binary 1 package_binary_tk 0}
  sampleextension {package_binary 1 package_binary_tk 0}
  tkhtml        {package_binary 1 package_binary_tk 1}
  canvas3d      {package_binary 1 package_binary_tk 1}
  bonjour       {package_binary 1 package_binary_tk 0}
  tclhttpd      {package_binary 0 package_binary_tk 0}
} {
  dict set properties package_name $mod
  dict set properties module $mod
  dict set properties fossil_url [list http://fossil.etoyoc.com/fossil/$mod]
  dict set properties toolset tea
  dict set properties distribution fossil
  gort::recipe_define $mod [dict merge $properties $props] {}
}

gort::recipe_define ffidl {
  package_name ffidl
  package_version 2.0
  fossil_url {https://chiselapp.com/user/pooryorick/repository/ffidl}
  distribution fossil
  toolset tea
} {}

gort::recipe_define tclvfs {
  fossil_url {http://fossil.etoyoc.com/fossil/tclvfs}
  package_binary 1
  package_binary_tk 0
  destroot_capabable 0
  modules tclvfs
  distribution fossil
  toolset tea
} {}

gort::recipe_define trf {
  fossil_url {http://fossil.etoyoc.com/fossil/trf}
  package_binary 1
  package_binary_tk 0
  destroot_capabable 0
  modules tclvfs
  distribution fossil
  toolset tea
} {}

gort::recipe_define udp {
  module udp
  fossil_url {http://fossil.etoyoc.com/fossil/tcludp}
  package_binary 1
  package_binary_tk 0
  package_version 1.0.10
  destroot_capabable 0
  distribution fossil
  toolset tea
} {}

gort::recipe_define itcl {
  module itcl
  fossil_url {http//core.tcl.tcl/itcl}
  distribution fossil
  toolset tea
} {}

gort::recipe_define itk {
  module itk
  fossil_url {http//core.tcl.tcl/itk}
  distribution fossil
  toolset tea
} {}


gort::recipe_define vectcl {
  git_branch trunk
  git_url https://github.com/auriocus/VecTcl
  package_name vectcl
  package_version 0.1.6
  package_binary 1
  package_binary_tk 0
  distribution git
  toolset tea
} {}

gort::recipe_define tdom {
  package_binary 1
  package_binary_tk 0
  git_branch trunk
  git_url https://github.com/tDOM/tdom
  package_name tdom
  package_version 0.8.3
  distribution git
  toolset tea
} {}

gort::recipe_define tcllib {
  package_name tcllib
  package_version 1.18
  fossil_url {http://fossil.etoyoc.com/fossil/tcllib}
  fossil_tag odie
  toolset sak
  distribution fossil
} {}

gort::recipe_define tklib {
  package_name tklib
  package_version 0.6
  fossil_url {http://fossil.etoyoc.com/fossil/tklib}
  toolset sak
  distribution fossil
} {}

set taolibinfo {
  fossil_tag trunk
  fossil_url http://fossil.etoyoc.com/fossil/taolib
  package_name taolib
  aliases {tao}
  package_version 3.1
  live_install 0
  package_requires {
    autoscroll
    fileutil
    odielib
    sak::doc
    sak::doc::auto
    sak::help
    sak::localdoc
    sak::util
    sqlite
    TclOO
  }
  toolset sak
  distribution fossil
}
if {$::tcl_platform(platform) eq "windows"} {
   dict set taolibinfo live_install 1
}
gort::recipe_define taolib $taolibinfo {}

gort::recipe_define tktable {
  package_name Tktable
  package_version 2.10
  package_binary 1
  package_binary_tk 1
  fossil_url {http://fossil.etoyoc.com/fossil/tktable}
  distribution fossil
  toolset tea
} {}
