###
# topic: c592732bb435d83ab1f70259fc56dbd7
###
proc ::cat fname {
    set fname [open $fname r]
    set data [read $fname]
    close $fname
    return $data
}

###
# topic: 64319f4600fb63c82b2258d908f9d066
# description: Script to build the VFS file system
###
proc ::copyDir {d1 d2} {

    puts [format {%*sCreating %s} [expr {4 * [info level]}] {} \
	      [file tail $d2]]
    file delete -force -- $d2
    file mkdir $d2

    foreach ftail [glob -directory $d1 -nocomplain -tails *] {
	set f [file join $d1 $ftail]
	if {[file isdirectory $f] && [string compare CVS $ftail]} {
	    copyDir $f [file join $d2 $ftail]
	} elseif {[file isfile $f]} {
	    file copy -force $f [file join $d2 $ftail]
	    if {$::tcl_platform(platform) eq {unix}} {
		file attributes [file join $d2 $ftail] -permissions 0644
	    } else {
		file attributes [file join $d2 $ftail] -readonly 1
	    }
	}
    }

    if {$::tcl_platform(platform) eq {unix}} {
	file attributes $d2 -permissions 0755
    } else {
	file attributes $d2 -readonly 1
    }
}

###
# topic: 15c41a8a701fb2afdfbd8d479d464bda
###
proc ::pkgIndexDir {root fout d1} {
    puts [format {%*sIndexing %s} [expr {4 * [info level]}] {} \
	      [file tail $d1]]
    set idx [string length $root]
    foreach ftail [glob -directory $d1 -nocomplain -tails *] {
	set f [file join $d1 $ftail]
	if {[file isdirectory $f] && [string compare CVS $ftail]} {
	    pkgIndexDir $root $fout $f
	} elseif {[file tail $f] eq "pkgIndex.tcl"} {
	    puts $fout "set dir \${VFSROOT}[string range $d1 $idx end]"
	    puts $fout [cat $f]
	}
    }
}

if {[llength $argv] < 3} {
    puts "Usage: VFS_ROOT TCLSRC_ROOT PLATFORM"
    exit 1
}
set PLATFORM       [lindex $argv 0]
set BASE_DIR       [lindex $argv 1]
set TCLSRC_ROOT    [lindex $argv 2]
set TKSRC_ROOT     [lindex $argv 3]
set TK_FULL_VERSION [string trim [lindex $argv 4] ']
set TK_DLL         [string trim [lindex $argv 5] ']

set TCL_SCRIPT_DIR [file join $BASE_DIR tcl]
file mkdir $TCL_SCRIPT_DIR
puts "Building [file tail $TCL_SCRIPT_DIR] for $PLATFORM"
copyDir ${TCLSRC_ROOT}/library ${TCL_SCRIPT_DIR}

if {$PLATFORM == "windows"} {
    set ddedll [glob -nocomplain ${TCLSRC_ROOT}/win/tcldde*.dll]
    puts "DDE DLL $ddedll"
    if {$ddedll != {}} {
	file copy $ddedll ${TCL_SCRIPT_DIR}/dde
    }
    set regdll [glob -nocomplain ${TCLSRC_ROOT}/win/tclreg*.dll]
    puts "REG DLL $ddedll"
    if {$regdll != {}} {
	file copy $regdll ${TCL_SCRIPT_DIR}/reg
    }
} else {
    # Remove the dde and reg package paths
    file delete -force ${TCL_SCRIPT_DIR}/dde
    file delete -force ${TCL_SCRIPT_DIR}/reg
}

# For the following packages, cat their pkgIndex files to tclIndex
if {$::tcl_platform(platform) eq {unix}} {
    file attributes [file join ${TCL_SCRIPT_DIR} tclIndex] -permissions 0744
} else {
    file attributes [file join ${TCL_SCRIPT_DIR} tclIndex] -readonly 0
}
set fout [open [file join ${TCL_SCRIPT_DIR} tclIndex] a]
puts $fout {#
# MANIFEST OF INCLUDED PACKAGES
#
set VFSROOT $dir
}
pkgIndexDir ${TCL_SCRIPT_DIR} $fout ${TCL_SCRIPT_DIR}
close $fout

if { $TKSRC_ROOT eq {} } {
  exit 0
}
set TK_SCRIPT_DIR [file join $BASE_DIR tk]
file mkdir $TK_SCRIPT_DIR

puts "Building [file tail $TK_SCRIPT_DIR] for $PLATFORM"
copyDir ${TKSRC_ROOT}/library ${TK_SCRIPT_DIR}
if { $TK_DLL eq {} } {
  exit 0
}
puts "Injecting Tk DLL"
if {$PLATFORM eq "windows"} {
  set dllsrc ${TKSRC_ROOT}/win/$TK_DLL
} else {
  set dllsrc ${TKSRC_ROOT}/unix/$TK_DLL
}
puts [list CP $dllsrc $TK_SCRIPT_DIR/$TK_DLL]
file copy -force $dllsrc $TK_SCRIPT_DIR/$TK_DLL
set fout [open ${TCL_SCRIPT_DIR}/tclIndex a]
puts $fout [string map [list @TKVERSION@ $TK_FULL_VERSION @TKDLL@ $TK_DLL] {
package ifneeded Tk @TKVERSION@ [list load $::tk_library/@TKDLL@ Tk]
}]
close $fout
exit 0

