#include "toadkit.h"

/*
 * Toadkit_MainHook --
 * Performs the argument munging for the shell
 */
#ifdef _WIN32
MODULE_SCOPE int Toadkit_MainHook(int *argc, TCHAR ***argv)
#else
MODULE_SCOPE int Toadkit_MainHook(int *argc, char ***argv)
#endif
{
    Tcl_FindExecutable(*argv[0]);
    CONST char *cp=Tcl_GetNameOfExecutable();
    Tcl_Zvfs_Boot(cp,TOADKIT_VFSMOUNT,TOADKIT_INIT);
    return 0;
}


/*
 *----------------------------------------------------------------------
 *
 * Toadkit_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in the interp's result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

MODULE_SCOPE int Toadkit_AppInit(Tcl_Interp *interp) {
  if ((Tcl_Init)(interp) == TCL_ERROR) {
      return TCL_ERROR;
  }
  /*
  * Start up all extensions.
  */
  Tclkit_Packages_Init(interp);
  /*
   * Call Tcl_CreateCommand for application-specific commands, if
   * they weren't already created by the init procedures called above.
   */

  /*
   * Specify a user-specific startup file to invoke if the application
   * is run interactively.  Typically the startup file is "~/.apprc"
   * where "app" is the name of the application.  If this line is deleted
   * then no user-specific startup file will be run under any conditions.
   */
  Tcl_SetVar(interp, "tcl_rcFileName", "~/.tclshrc", TCL_GLOBAL_ONLY);
  return TCL_OK;
}