package require nettool
package require nettool::available_ports  ;# Provides port seeking functions

###
# topic: 43cbcb22d6b5dc4cea973f9e432d6d1ee49fbd95
###
proc ::fossil_host {url filename} {
  set port [::nettool::allocate_port 10000]
  set fn [file rootname [file tail $filename]]
  if {[info exists ::fossil_repo($url/$fn)]} continue

  try {
    set baseurl http://[dict get $::httpd server name:]:[dict get $::httpd server port:]/${url}/$fn
    set siteurl /${url}/$fn

    set opener "|$::gort(fossil) server --port $port --localhost --baseurl $baseurl $filename"
    dict set ::fossil_server $url $fn channel: [open $opener w]
    dict set ::fossil_server $url $fn baseurl: $baseurl
    dict set ::fossil_server $url $fn siteurl: $siteurl
    dict set ::fossil_server $url $fn port: $port
    dict set ::fossil_server $url $fn pid: [pid [dict get $::fossil_server $url $fn channel:]]
  } on error {e eo} {
    catch {dict unset ::fossil_server $url $fn}
    ::nettool::release_port $port
    puts stderr "FOSSIL OPEN ERR: $e ($eo)"
    exit
  } on ok {} {
    #puts stderr "OPENED FOSSIL $fn: [dict get $::fossil_server $url $fn]"
  } 
}

