###
# teapot schema
# This schema is designed to conform to the same standard
# used by the ActiveState teapot.
#
# It was reverse engineered through the dubious means of
# sqlite INDEX ; .schema
# sqlite INSTALLLOG ; .schema
###
namespace eval ::teapotclient {}

set ::teapotclient::schema(INDEX) {
CREATE TABLE teapot
		(  name      TEXT NOT NULL,
		   version   TEXT NOT NULL,
		   rcsid     TEXT NOT NULL
		   );
CREATE TABLE instances
		(  type      TEXT NOT NULL,
		   name      TEXT NOT NULL,
		   version   TEXT NOT NULL,
		   platform  TEXT NOT NULL,
		   isprofile INTEGER NOT NULL,
		   file	     TEXT NOT NULL,
		   PRIMARY KEY (type,name, version, platform),
		   UNIQUE (file)
		   );
CREATE TABLE meta
		(  file	 TEXT NOT NULL,
		   key	 TEXT NOT NULL,
		   value TEXT NOT NULL,
		   PRIMARY KEY (file, key)
		   );
CREATE INDEX meta_file
		ON           meta (file);
INSERT INTO "teapot" VALUES('TEAPOT','0.2','$Id$');
}

set ::teapotclient::schema(INSTALLLOG) {
CREATE TABLE teapot
		(  name      TEXT NOT NULL,
		   version   TEXT NOT NULL,
		   rcsid     TEXT NOT NULL
		   );
CREATE TABLE journal
		(  seconds   INTEGER NOT NULL, -- seconds since the epoch
		   serial    INTEGER NOT NULL, -- serial number per client invocation
		   action    INTEGER NOT NULL, -- reference to -> action
		   entity    TEXT NOT NULL,    -- entity type
		   name      TEXT NOT NULL,    -- entity name
		   version   TEXT NOT NULL,    -- entity version
		   arch      TEXT NOT NULL,    -- entity architecture
		   PRIMARY KEY (seconds, serial)
		   );
CREATE TABLE action
		(  id   INTEGER NOT NULL,
		   text TEXT NOT NULL,
		   PRIMARY KEY (id)
		   );
INSERT INTO "teapot" VALUES('TEAPOT-JOURNAL','0.1','$Id$');
INSERT INTO "action" VALUES(0,'install');
INSERT INTO "action" VALUES(1,'remove');
}