gort::class create ::gort::tclmake {
  

  variable sources {}
  variable headers {}

  method SourceFilePath filename {
    return [file normalize $filename]
  }
  
  method sources::add {filename {info {}}} {
    my variable sources
    set ext [file extension $filename]
    switch $ext {
      .h {
        set default {scan 1 verbatim 0}
      }
      .c {
        set default {module {} ignore 0 scan 1 verbatim 0 cases {}}
        dict set default ofile [file rootname $filename].o
      }
      default {
        set default {scan 0}
      }
    }
    dict set default mtime [file mtime $filename]
    dict set default size [file size $filename]
    dict set default extension $ext
    dict set sources [my SourceFilePath $filename] [dict rmerge $defaults $info]
  }
  
  method sources::set {filename args} {
    set filename [my SourceFilePath $filename]
    my variable sources
    if {![dict exists $sources $filename]} {
      my sources add $filename $args
    } else {
      dict set sources $filename {*}$args
    }
  }
  
  ###
  # topic: f11da5f705442524715e8f8fe9af5276
  # title: Add a path containing C code
  ###
  method add_directory {here {cmdconfig {}}} {
    my variable define
    puts [list ADD DIRECTORY $here]
    set config [dict merge {
      cthulhu-ignore-hfiles {}
      cthulhu-ignore-cfiles {}
      build-ignore-cfiles {}
      cthulhu-trace-cfiles {}
    } $define(config) $cmdconfig]
  
    dict with config {}
    set cwd [pwd]
    set here [file normalize $here]
    ###
    # Execute any .tcl scripts in the generic directory
    ###
    foreach file [lsort  [glob -nocomplain [file join $here *.tcl]]] {
      if {[file tail $file] in "make.tcl shed.tcl pkgIndex.tcl"} continue
      cd $here
      uplevel #0 [list source $file]
    }
    ###
    # Build a list of all public header files that
    # need to be amalgamated into the publicly exported
    # version
    ###
    set hfilecount 0
    foreach file [lsort  [glob -nocomplain [file join $here *.h]]] {
      incr hfilecount
      set fname [file tail $file]
      if {${cthulhu-ignore-hfiles} eq "*"} continue
      if { $fname in ${cthulhu-ignore-hfiles} } continue
      if {[string match *_cases.h $fname]} continue
      my sources add $file
    }
    if {$hfilecount} {
      my define add include_directory [my SourceFilePath $here]
    }
    foreach file [lsort  [glob -nocomplain [file join $here *.c]]] {
      if {[file tail $file] in ${build-ignore-cfiles} } continue
      my sources add $file
    }
    cd $cwd  
  }
  
  ###
  # topic: 1d3a911fd58337df92205759a6d092c3
  # title: Add a source file in Tcl that produces a C file
  ###
  method add_dynamic {csource tclscript} {
    my sources set $cfilename tclscript $tclfilename
  }
  
  ###
  # topic: d10665e8da4dd0781bb0a9ced5486e40
  # title: Add a pure-tcl library
  ###
  method add_library {here {cmdconfig {}}} {
    my variable define
    set config [dict merge {
      cthulhu-ignore-tclfiles {}
    } $define(config) $cmdconfig]
  
    dict with config {}
    set here [file normalize $here]
    foreach file [lsort [glob -nocomplain $here/*.tcl]] {
      if {[file tail $file] in ${cthulhu-ignore-tclfiles}} continue
      set libfilename [::fileutil::relative [my define get srcdir] $libfilename]
    }
  }
  
  ###
  # topic: ccfe65b26705afc498e08d3004031066
  # title: Detect where we need to produce a _cases.h file to automate a C source
  ###
  method detect_cases filename {
    my sources set $filename cases [my detect_cases_do $filename]
  }
  
  method detect_cases_put_item {f x} {
    upvar 1 col col
    if {$col==0} {puts -nonewline $f "   "}
    if {$col<2} {
      puts -nonewline $f [format " %-21s" $x]
      incr col
    } else {
      puts $f $x
      set col 0
    }
  }
  
  method detect_cases_finalize {f} {
    upvar 1 col col
    if {$col>0} {puts $f {}}
    set col 0
  }
  
  ###
  # topic: aacfe07625f74f93dada2159f53fca32
  ###
  method detect_cases_do cfile {
    set dirname [my define get BUILDDIR]
    set fin [open $cfile r]
    while {[gets $fin line] >= 0} {
      if {[regexp {^ *case *([A-Z]+)_([A-Z0-9_]+):} $line all prefix label]} {
        lappend cases($prefix) $label
      }
    }
    close $fin
  
    set col 0
    
    foreach prefix [array names cases] {
      set hfile [file join $dirname [string tolower $prefix]_cases.h]
      if {[file exists $hfile] && [file mtime $hfile]>[file mtime $cfile]} continue
      set f [open $hfile w]
      fconfigure $f -translation crlf
      puts $f "/*** Automatically Generated Header File - Do Not Edit ***/"
      puts $f "  const static char *${prefix}_strs\[\] = \173"
      set lx [lsort  $cases($prefix)]
      foreach item $lx {
        my detect_cases_put_item $f \"[string tolower $item]\",
      }
      my detect_cases_put_item $f 0
      my detect_cases_finalize $f
      puts $f "  \175;"
      puts $f "  enum ${prefix}_enum \173"
      foreach name $lx {
        regsub -all {@} $name {} name
        my detect_cases_put_item $f ${prefix}_[string toupper $name],
      }
      my detect_cases_finalize $f
      puts $f "  \175;"
      puts $f "\
    int index;
    if( objc<2 ){
      Tcl_WrongNumArgs(interp, 1, objv, \"METHOD ?ARG ...?\");
      return TCL_ERROR;
    }
    if( Tcl_GetIndexFromObj(interp, objv\[1\], ${prefix}_strs,\
              \"option\", 0, &index)){
      return TCL_ERROR;
    }
    switch( (enum ${prefix}_enum)index )"
      close $f
    }
    set result {}
    foreach item [array names cases] {
      lappend result [string tolower ${item}_cases.h]
    }
    return $result
  }


  ###
  # topic: 41d95037e5a1cab76939150efdef8939
  # title: Declare an end to modifications of ::project
  # description:
  #    This directive is placed after the last set ::CTHULHU(X) Y
  #    but before the first ::my add_*
  ###
  method init args {
    my variable define
    my variable cases
    my variable sources
    my variable headers
    my variable scanlist
    my variable headers_verbatim
    set cases {}
    set sources {}
    set headers {}
    set scanlist {}
    set headers_verbatim {}
    array set define(config) [dict merge {
      target pkg
    } $args]
  }
  
  ###
  # topic: 17c9931c3ec5ba115efafaaaa3cf61ed
  ###
  method mk_lib_init.c outfile {
    global project cout
    set cout      [open $outfile w]
    fconfigure $cout -translation crlf
    puts $cout [my define cget standard_header]
    puts $cout "#include \"$::CTHULHU(h_file_int)\""
    
    puts $cout "
    
    extern int DLLEXPORT [my define get init_funct]( Tcl_Interp *interp ) \{
      Tcl_Namespace *modPtr\;
    "
    puts $cout {
        /* Initialise the stubs tables. */
    #ifdef USE_TCL_STUBS
        if (
            !Tcl_InitStubs(interp, "8.3", 0)
        ) {
            return TCL_ERROR;
        }
    #endif
    }
  
    foreach module [my define cget modules] {
      puts $cout "  if(${module}(interp)) return TCL_ERROR\;"
    }
    foreach {nspace cmds} [lsort -stride 2 -dictionary [my define get namespace_commands]] {
      puts $cout "
      modPtr=Tcl_FindNamespace(interp,\"$nspace\",NULL,TCL_NAMESPACE_ONLY)\;
      if(!modPtr) {
        modPtr = Tcl_CreateNamespace(interp, \"$nspace\", NULL, NULL);
      }
      "
      foreach {command cfunct} [lsort -stride 2 -dictionary $cmds] {
        puts $cout "  Tcl_CreateObjCommand(interp,\"::${nspace}::${command}\",(Tcl_ObjCmdProc *)$cfunct,NULL,NULL);"
      }
      puts $cout {
      Tcl_CreateEnsemble(interp, modPtr->fullName, modPtr, TCL_ENSEMBLE_PREFIX);
      Tcl_Export(interp, modPtr, "[a-z]*", 1);
      }
    }
    
    puts $cout {
        /* Register the package. */}
    puts $cout "    if (Tcl_PkgProvide(interp, \"[my define get package_name]\", \"[my define get package_version]\")) return TCL_ERROR\;"    
    puts $cout "  return TCL_OK\;\n\}"
    close $cout
  }
  
  ###
  # topic: 17c9931c3ec5ba115efafaaaa3cf61ed
  ###
  method mk_app_init.c outfile {
    global project cout
    set cout      [open $outfile w]
    fconfigure $cout -translation crlf
    puts $cout [my define cget standard_header]
    puts $cout "#include \"$::CTHULHU(h_file_int)\""
    
    puts $cout "
    
    int ${CTHULHU(init_funct)}_static( Tcl_Interp *interp ) \{
      Tcl_Namespace *modPtr\;
    "
  
    foreach module $::CTHULHU(modules) {
      puts $cout "
    if(${module}(interp)) \{
      return TCL_ERROR\;
    \}
    "
    }
    foreach {nspace cmds} [lsort -stride 2 -dictionary [my define get namespace_commands]] {
      puts $cout "
      modPtr=Tcl_FindNamespace(interp,\"$nspace\",NULL,TCL_NAMESPACE_ONLY)\;
      if(!modPtr) {
        modPtr = Tcl_CreateNamespace(interp, \"$nspace\", NULL, NULL);
      }
      "
      foreach {command cfunct} [lsort -stride 2 -dictionary $cmds] {
        puts $cout "  Tcl_CreateObjCommand(interp,\"::${nspace}::${command}\",(Tcl_ObjCmdProc *)$cfunct,NULL,NULL);"
      }
      puts $cout {
      Tcl_CreateEnsemble(interp, modPtr->fullName, modPtr, TCL_ENSEMBLE_PREFIX);
      Tcl_Export(interp, modPtr, "[a-z]*", 1);
      }
    }
    
    puts $cout {
        /* Register the package. */}
    puts $cout "    if (Tcl_PkgProvide(interp, \"[my define get package_name]\", \"[my define get package_version]\")) return TCL_ERROR\;"
    puts $cout "  return TCL_OK\;\n\}"
    close $cout
  }
  
  ###
  # Generate targets for SMAKE
  ###
  method smake_targets {bldpath srcpath} {
    my variable sources
    global project
    file mkdir $bldpath
    set pkg_sources {}
    set pkg_objects {}
    foreach {source info} $sources {
      if {[dict exists $info ofile]} continue
      dict with info {}
      if {$extension ne ".c"} continue
      if {$ignore} continue
      if {$module eq {}} {
        set ofile [file join $bldpath [string trimleft [string map {{ } _ / _ .c .o .. {}} $module/$source] _]]
      } else {
        set ofile [file join $bldpath [string trimleft [string map {/ _ .c .o .. {}} [lrange [file split $source] end-2 end] _]]
      }
      set cfile [::fileutil::relative $$bldpath $source]
      lappend pkg_sources $cfile
      dict set sources $source cfile $cfile
      dict set sources $source ofile $ofile
    }
    set MYINCLUDES {}
    lappend MYINCLUDES -I.
    lappend MYINCLUDES -I$bldpath
    foreach ipath [my define get include_paths] {
      lappend MYINCLUDES -I[::fileutil::relative $bldpath [file join $srcpath $ipath]]
    }
    my define PKG_OBJECTS $pkg_objects
    my define PKG_SOURCES $pkg_sources
    
    foreach {csource cinfo} $sources {
      if {[dict exists $cinfo ofile]} {
        set ofile [dict get $cinfo ofile]
      } else {
        set ofile {}
      }
      set cfile [file join $srcpath $csource]
      set hfiles {}
      if {[dict exists $cinfo cases]} {
        package require cthulhu::mktclotps
        foreach hfile [dict get $cinfo cases] {
          target $hfile [list depends {} [list mktclopts $cfile $bldpath]]
          lappend hfiles $hfile
        }
      }
      puts [list OFILE $ofile]
      puts [list CFILE $cfile]
      if {[dict exists $cinfo tclscript]} {
        target $cfile [list depends {} [list tclexec {*}[dict exists $cinfo tclscript]]]
        if {$ofile ne {}} {
          target $ofile [list depends [list {*}$hfiles $cfile] [list my <toolset> compile [list {*}[dict getnull $cinfo extra] {*}$MYINCLUDES] $cfile -o $ofile]
        }
      } else {
        if {$ofile ne {}} {
          target $ofile [list depends $hfiles [list my <toolset> compile [list {*}[dict getnull $cinfo extra] {*}$MYINCLUDES] $cfile -o $ofile]]
        }
      }
    }
  }
  
  ###
  # Generate the section of a Gnu-Makefile
  ###
  method mk_sources {bldpath srcpath outfile} {
    my variable sources
    global project
    file mkdir $bldpath
    set pkg_sources {}
    set pkg_objects {}
    foreach {source info} $sources {
      if {[dict exists $info ofile]} continue
      dict with info {}
      if {$extension ne ".c"} continue
      if {$ignore} continue
      if {$module eq {}} {
        set ofile [file join $bldpath [string trimleft [string map {{ } _ / _ .c .o .. {}} $module/$source] _]]
      } else {
        set ofile [file join $bldpath [string trimleft [string map {/ _ .c .o .. {}} [lrange [file split $source] end-2 end] _]]
      }
      set cfile [::fileutil::relative $$bldpath $source]
      lappend pkg_sources $cfile
      dict set sources $source cfile $cfile
      dict set sources $source ofile $ofile
    }
    set MYINCLUDES {}
    lappend MYINCLUDES -I.
    lappend MYINCLUDES -I$bldpath
    foreach ipath [my define get include_paths] {
      lappend MYINCLUDES -I[::fileutil::relative $bldpath [file join $srcpath $ipath]]
    }
    my define PKG_OBJECTS $pkg_objects
    my define PKG_SOURCES $pkg_sources
    
    #puts $fout "build/$CTHULHU(c_file):"
    #puts $fout "\t\${TCLSH} scripts/cthulhu.tcl\n"
    
    foreach {csource cinfo} $sources {
      if {[dict exists $cinfo ofile]} {
        set ofile [dict get $cinfo ofile]
      } else {
        set ofile {}
      }
      set hfiles {}
      if {[dict exists $cinfo cases]} {
        foreach hfile [dict get $cinfo cases] {
          puts $fout "$hfile:"
          puts $fout "\t\$(TCLSH_PROG) scripts/mktclopts.tcl [dict get cinfo $cfile]\n"
          lappend hfiles $hfile
        }
      }
      if {[dict exists $cinfo tclscript]} {
        set cfile [file rootname $ofile].c
        puts $fout "${cfile}:"
        puts $fout "\t\$(TCLSH_PROG) [dict get $cinfo tclscript] [file join $bldpath $cfile].c\n"
        if {$ofile != {}} {
          puts $fout "$ofile: $hfiles"
          puts $fout "\t\$(COMPILE) [dict getnull $cinfo extra] \$(MYINCLUDES) -c $cfile -o \$@\n"
        }
      } else {
        if {$ofile != {}} {
          puts $fout "$ofile: $hfiles"
          puts $fout "\t\$(COMPILE) [dict getnull $cinfo extra] \$(MYINCLUDES) -c [dict get $cinfo cfile] -o \$@\n"
        }
      }
    }
    close $fout
  }
  
  ###
  # topic: f7eec240dada25d73c1f68a877fa40be
  # title: Produce the PROJECT.decls file
  # description: Tools for automating the process of building stubs libraries
  ###
  method mk_stub_decls {pkgname mkhdrfile path} {
    set outfile [file join $path/$pkgname.decls]
    
    ###
    # Build the decls file
    ###
    set fout [open $outfile w]
    puts $fout [subst {###
    # $outfile
    #
    # This file was generated by [info script]
    ###
    
    library $pkgname
    interface $pkgname
    }]
    
    set fin [open $mkhdrfile r]
    set thisline {}
    set functcount 0
    while {[gets $fin line]>=0} {
      append thisline \n $line
      if {![info complete $thisline]} continue
      set readline $thisline
      set thisline {}
      set type [lindex $readline 1]
      if { $type ne "f" } continue
    
      set infodict [lindex $readline end]
      if {![dict exists $infodict definition]} continue
      set def [dict get $infodict definition]
      set def [string trim $def]
      set def [string trimright $def \;]
      if {![string match "*STUB_EXPORT*" $def]} continue
      puts $fout [list declare [incr functcount] $def]
      
    }
    close $fin
    close $fout
    
    ###
    # Build [package]Decls.h
    ###
    set hout [open [file join $path ${pkgname}Decls.h] w]
    
    close $hout
  
    set cout [open [file join $path ${pkgname}StubInit.c] w]
  puts $cout [string map [list %pkgname% $pkgname %PkgName% [string totitle $pkgname]] {
  #ifndef USE_TCL_STUBS
  #define USE_TCL_STUBS
  #endif
  #undef USE_TCL_STUB_PROCS
  
  #include "tcl.h"
  #include "%pkgname%.h"
  
   /*
   ** Ensure that Tdom_InitStubs is built as an exported symbol.  The other stub
   ** functions should be built as non-exported symbols.
   */
  
  #undef TCL_STORAGE_CLASS
  #define TCL_STORAGE_CLASS DLLEXPORT
  
  %PkgName%Stubs *%pkgname%StubsPtr;
  
   /*
   **----------------------------------------------------------------------
   **
   **  %PkgName%_InitStubs --
   **
   **        Checks that the correct version of %PkgName% is loaded and that it
   **        supports stubs. It then initialises the stub table pointers.
   **
   **  Results:
   **        The actual version of %PkgName% that satisfies the request, or
   **        NULL to indicate that an error occurred.
   **
   **  Side effects:
   **        Sets the stub table pointers.
   **
   **----------------------------------------------------------------------
   */
  
  char *
  %PkgName%_InitStubs (Tcl_Interp *interp, char *version, int exact)
  {
    char *actualVersion;
    
    actualVersion = Tcl_PkgRequireEx(interp, "%pkgname%", version, exact,
                                                                     (ClientData *) &%pkgname%StubsPtr);
    if (!actualVersion) {
          return NULL;
    }
    
    if (!%pkgname%StubsPtr) {
          Tcl_SetResult(interp,
                                    "This implementation of %PkgName% does not support stubs",
                                    TCL_STATIC);
          return NULL;
    }
    
    return actualVersion;
  }
  }]
    close $cout
  }
  
  ###
  # topic: ba1d2c7e8eab96029e434d54f917ef5a
  ###
  method mkhdr_index {hout docfileout} {
    my variable define sources
    global project
    my sources set [file join [my define get BUILDDIR] [my define get h_file_int]] scan 0
    my sources set [::file normalize  [file join [my define get BUILDDIR] [my define get c_file]]] scan 0

    foreach {file info} $sources {
      if {$ext ne {.h}} continue
      if {[dict get $info verbatim] eq 1} continue
      if {[dict get $info scan] ne 1} continue
      lappend scanlist $file
    }
    foreach {file info} $sources {
      if {$ext ni {.c .c++ .cpp}} continue
      if {[dict get $info scan] ne 1} continue
      lappend scanlist $file
    }
    puts "WRITING INTERNAL HEADERS TO $hout"
    set fout [open $hout w]
    fconfigure $fout -translation crlf
  puts $fout "/*
  ** DO NOT EDIT THIS FILE
  ** It is automagically generated by scripts/cthulhu.tcl
  */"
    puts $fout "/* Verbatim headers */"

    foreach {file info} $sources {
      if {$ext ne {.h}} continue
      if {[dict get $info verbatim] ne 1} continue
      if {[dict get $info scan] ne 1} continue
      set type [file type $file]
      if {$type ne "file"} continue
      puts $fout "/*\n *$file \n*/"
      set fin [open $file r]
      puts $fout [read $fin]
      close $fin
    }
    puts $fout "/* FUNCTION DECLARATIONS */"
    ###
    # Do get around platform line breaks, we output to a tmp file
    # and concat in Tcl
    ###
    set crscanlist {}
    foreach file $scanlist {
      set crfile $file.cr[file extension $file]
      set rawfin [open $file r]
      set rawfout [open $crfile w]
      fconfigure $rawfout -translation lf
      puts $rawfout [read $rawfin]
      close $rawfout
      close $rawfin
      lappend crscanlist $crfile
    }
    
    my mkhdr -h -- {*}$crscanlist > $hout.cr
    set rawfin [open $hout.cr r]
    puts $fout [read $rawfin]
    close $rawfin
    file delete $hout.cr
    close $fout
    
    my mkhdr -doc -- {*}$scanlist > $docfileout
    
    foreach file $crscanlist {
      file delete $file
    }
  
    set fin [open $hout r]
    while {[gets $fin line]>=0} {
      if {[regexp TCL_MODULE $line] || [regexp DLLEXPORT $line]} {
        foreach regexp {
             {(.*) ([a-zA-Z_][a-zA-Z0-9_]*) *\((.*)\)}
             {(.*) (\x2a[a-zA-Z_][a-zA-Z0-9_]*) *\((.*)\)}
        } {
          if {[regexp $regexp $line all keywords funcname arglist]} {
            my define add modules $funcname
            break
          }
        }
      }
    }
  }
  
  method find_mkhdr {} {
    if {[my define exists mkhdr_exe]} {
      return [my define get mkhdr_exe]
    }
    set gortmkdr [file join $::gort(prefix) bin mkhdr[my define cget exe_suffix]]
    if {[file executable $gortmkdr]} {
      set result [list exec $gortmkdr]
      my define set mkhdr_exe $result
      return $result
    }
    set exename [::gort::find-EXE MKHDR]
    if {$exename ne {}} {
      set result [list exec [::file normalize  $exename]]
      my define set mkhdr_exe $result
      return $result
    }
    set ofile [file join [my define get BUILDDIR] mkhdr.o]
    my <toolset> compile [file join $::gort(sandbox) gort scripts mkhdr.c] $ofile
    my <toolset> link-executable $ofile [file rootname $ofile].a
    file copy -force [file rootname $ofile].a $gortmkdr 
    set result [list exec $gortmkdr]
    my define set mkhdr_exe $result
    return $result
  }
  
  
  method mkhdr args {
    set cmd [my find_mkhdr]
    {*}${cmd} {*}$args
  }
  
  
  method tea_init {} {
    set nodots [my cget nodots]
    if {$nodots eq {}} {
      if {[my <toolset> is_windows]} {
        set nodots 1
      }
    } elseif {[string is true -strict $nodots]} {
      set nodots 1
    } else {
      set nodots 0
    }
    
    set libver [my define get package_version]
    lassign [regsub {^(\d)\.(\d)\.\d+$} [package provide Tcl] {\1.\2}] tclver
    if {[string is true -strict $nodots]} {
      set libver [string map {. ""} $libver]
      set tclver [string map {. ""} $tclver]
    }
    set prefix [my define cget prefix]
    set pkgdir [my cget pkgdir]
    if { $pkgdir eq {}} {
      set pkgdir [file join $prefix lib]
    }
    my define pkgdir $pkgdir  
    my define docdir [file join $prefix share doc]
    my define exadir [file join $prefix share examples]
    my define datarootdir [file join $prefix share]
  
    
    my variable define
    foreach {item value} [array get define package_*] {
      set field [string range $item 8 end]
      my define set PACKAGE_[string toupper $field] $value
      my define set PKG_[string toupper $field] $value
    }

    define PKG_NAME $::project(name)
    define PKG_VER $::project(pkgvers)
    
    set shlibver [lindex [opt-val shlibver 0.0] end]
    define SHLIB_VER $shlibver
    if {$shlibver ni {0.0 {}}} {
      append shlibspec [format [get-define SH_SOEXTVER] $shlibver]
    } else {
      set shlibspec [get-define SH_SOEXT]
    }
    define SHLIB_SPEC $shlibspec
    
    define EXT_INC_SPEC ""
    define EXT_LIB_DIR_SPEC ""
    define EXT_LIB_SPEC ""
  
    define TCL_INC_SPEC $::odie_tcl(include_spec)
    if {"tk" in $project(libs)} {
      define TCL_LIB_SPEC "$::odie_tcl(build_stub_lib_spec) $::odie_tk(build_stub_lib_spec)"
    } else {
      define TCL_LIB_SPEC $::odie_tcl(build_stub_lib_spec)
    }
    
    set ::odie_package(name) $::project(pkgname)
    set ::odie_package(version) $::project(pkgvers)
    set ::odie_package(ver) $::project(pkgvers)
    set ::odie_package(libfile) lib${::project(name)}$libver[get-define SHLIB_SPEC]
    set ::odie_package(lib_file) $::odie_package(libfile)
    if {"tk" in $project(libs)} {
      set ::odie_package(libs) $::odie_tk(libs)
    } else {
      set ::odie_package(libs) $::odie_tcl(libs)    
    }
    foreach lib $project(libs) {
      if { $lib in {tcl tk} } continue
      if { "-l$lib" ni $::odie_package(libs) } {
        lappend ::odie_package(libs) "-l$lib"
      }
    }
    set idx 0
    set start 0
    set end 0
    if {"tk" in $project(libs)} {
      set str $::odie_tk(defs)
    } else {
      set str $::odie_tcl(defs)
    }
    set len [string length $str]
    set token {}
    set next {}
    set item {}
    set opts {}
    while {$idx < $len} {
    ###
    # Seek start of opt
    ###
    if {[string range [string trim $item] end-1 end] != "-D"} {
      append item [string index $str $idx]
      incr idx
    } else {
      set end [expr {$idx-3}]
      set token [string trim [string range $str $start $end]]
      lappend opts $token
      set item {}
      set start $idx
      incr idx
    }
    }
    set token [string trim [string range $str $start end]]
    lappend opts $token
    
    set defs "-DPACKAGE_NAME=\"$::project(pkgname)\" -DPACKAGE_TARNAME=\"$::project(name)\" -DPACKAGE_VERSION=\"$::project(pkgvers)\" -DPACKAGE_STRING=\"$::project(pkgname) $::project(pkgvers)\""
    foreach opt [lrange $opts 4 end] {
    append defs " -D$opt"
    }
    set ::odie_package(defs) $defs
    set ::odie_package(cflags)  {}
    define DEFS $::odie_package(defs)
    set cflags { -pipe }
    if {[opt-bool debugbld]} {
    append cflags {${CFLAGS_DEBUG} ${CFLAGS_WARNING}}
    } else {
    append cflags {${CFLAGS_DEFAULT} ${CFLAGS_WARNING}}
    }
    if {[opt-bool static]} {
    } else {
    append cflags { ${SHLIB_CFLAGS}}
    }
    define CCFLAGS $cflags
    
    if {[lindex [opt-val nothreads] end] eq "1"} {
          define TH_CFLAGS ""
          define TH_LIBS ""
          define TH_DEFS ""
    } else {
          define TH_CFLAGS -pthread
          define TH_LIBS ""
          define TH_DEFS "-DTCL_THREADS=1 -DUSE_THREAD_ALLOC=1"
    }
    
    set tdefs {}
    lappend tdefs -DUSE_TCL_STUBS=1
    if {"tk" in $project(libs)} {
      lappend tdefs -DUSE_TK_STUBS=1
    }
    if {[lindex [opt-val debugbld] end] eq "1"} {
          define DEBUG ""
          define NDEBUG "#"
          lappend tdefs -DTCL_MEM_DEBUG=1
    } else {
          define DEBUG "#"
          define NDEBUG ""
    }
    define TDEFS [join $tdefs]
    
    set opt_defs {}
    define OPT_DEFS [join $opt_defs]
    
    define CCFLAGS $::odie_tcl(extra_cflags)
    define CFLAGS_WARN $::odie_tcl(cflags_warning)
    define CFLAGS_OPT $::odie_tcl(cflags_optimize)
    define CFLAGS_DEBUG $::odie_tcl(cflags_debug)
    
    foreach path $::project(include_paths) {
    append ::odie_package(includes) " " -I$path
    }
    
    set ::odie_package(headers) $::project(h_file)
    
    foreach {var val} [array get ::odie_package] {
    define PACKAGE_[string toupper $var] $val
    define PKG_[string toupper $var] $val
    }
    
    
    define LIB lib${::project(name)}$libver[get-define SHLIB_SPEC]
    define PKG_LIB lib${::project(name)}$libver[get-define SHLIB_SPEC]
    
    define PKG_TCL_MODULES_ROOT [file join $::project(srcdir) modules]
    define PKG_TCL_SOURCES ""
    set modules {}
    foreach path [glob -nocomplain [file join $::project(srcdir) modules *]] {
    if {[file isdirectory $path]} {
      lappend modules [file tail $path]
    }
    }
    define PKG_TCL_MODULES $modules
    if {[info exists ::project(pkginit)]} {
      define PKG_LIB_INIT $::project(pkginit)
    } else {
      define PKG_LIB_INIT $::project(name)
    }
  }
}
