###
# GCC Specific initialization for toolsets
###
my variable config
my variable define
my variable cc_cache
array unset cc_cache *
if {![info exists config]} {
  set config {}
}    

if {[dict exists $config host]} {
  set host [dict get $config host]
} else {
  # Start Local
  set host [my target]
}
my define set host $host

# Initialise some values from the environment or commandline or default settings
foreach i {LDFLAGS LIBS CPPFLAGS LINKFLAGS {CFLAGS "-g -O2"}} {
  lassign $i var default
  my define set $var [my get-env $var $default]
}

if {[my env-is-set CC]} {
  # Set by the user, so don't try anything else
  set try [list [my get-env CC ""]]
} else {
  # Try some reasonable options
  set try [list [my define cget cross]cc [my define cget cross]gcc]
}

set exec [::gort::find-EXE strip]
my define set STRIP $exec

set exec [::gort::find-EXE {*}$try]    
if {$exec eq ""} {
  error "Could not find a C compiler. Tried: [join $try ", "]"
}
my define set CC $exec
my define set CPP [my get-env CPP "$exec -E"]

# XXX: Could avoid looking for a C++ compiler until requested
# Note that if CXX isn't found, we just set it to "false". It might not be needed.
my define set CXX [::gort::find-EXE CXX [my define cget cross]c++ [my define cget cross]g++ c++ false]

# CXXFLAGS default to CFLAGS if not specified
my define set CXXFLAGS [my get-env CXXFLAGS [my define cget CFLAGS]]

# May need a CC_FOR_BUILD, so look for one
my define set CC_FOR_BUILD [::gort::find-EXE CC_FOR_BUILD cc gcc false]

if {[my define cget CC] eq ""} {
  error "Could not find a C compiler. Tried: [join $try ", "]"
}

my define set CCACHE [::gort::find-EXE CCACHE]

# Initial cctest settings
my cc-store-settings {-cflags {} -includes {} -declare {} -link 0 -lang c -libs {} -code {} -nooutput 0}
set ::autosetup(cc-include-deps) {}

my msg-result "C compiler...[my define cget CCACHE] [my define cget CC] [my define cget CFLAGS]"
if {[my define cget CXX] ne "false"} {
  my msg-result "C++ compiler...[my define cget CCACHE] [my define cget CXX] [my define cget CXXFLAGS]"
}
my msg-result "Build C compiler...[my define cget CC_FOR_BUILD]"

  
# On Darwin, we prefer to use -g0 to avoid creating .dSYM directories
# but some compilers may not support it, so test here.
switch -glob -- $host {
  *-*-darwin* {
    if {[my cctest -cflags {-g0}]} {
      my define set cc-default-debug -g0
    }
    my define set LDFLAGS {-headerpad_max_install_names -Wl,-search_paths_first}
    my define set CFLAGS  {-O2 -DALLOW_EMPTY_EXPAND -arch x86_64 -pipe -fvisibility=hidden   -isysroot /Developer/SDKs/MacOSX10.6.sdk -mmacosx-version-min=10.5}
    my define set CPPFLAGS  {-O2 -DALLOW_EMPTY_EXPAND -arch x86_64  -pipe -fvisibility=hidden   -isysroot /Developer/SDKs/MacOSX10.6.sdk -mmacosx-version-min=10.5}
    my define set CXXFLAGS  {-O2 -DALLOW_EMPTY_EXPAND -arch x86_64  -pipe -fvisibility=hidden   -isysroot /Developer/SDKs/MacOSX10.6.sdk -mmacosx-version-min=10.5}

  }
}

if {![my cc-check-includes stdlib.h]} {
  error "Compiler does not work. See config.log"
}

