###
# Tracking information for download, compile, install, etc
###
::namespace eval ::shed::event {}

###
# topic: 46af43b297df419610f117f2720c008fc9046d62
###
shed::class create ::shed::classes::event {
  
  property subordinate 0
  meta set schema table: event
  meta set schema order: 2
  meta set schema dbfields: {uuid timestamp class objclass objuuid outcome}

  meta set schema create_sql: {
create table event(
  uuid uuid primary key,
  timestamp integer,
  class string,
  objclass string,
  objuuid string,
  outcome string
);
create table event_property (
  event uuid,
  field string,
  value value,
  PRIMARY KEY (event,field),
  FOREIGN KEY(event) REFERENCES event(uuid) ON UPDATE CASCADE
);
create table object_state (
  objclass string,
  objuuid uuid,
  field string,
  value value,
  assertion string, --Tcl script to evalute if condition still true
  PRIMARY KEY (objclass,objuuid,field)
);
  }
}