::namespace eval ::shed::class {}

::namespace eval ::shed::package {}

if {[info command ::noop] eq {}} {
  proc ::noop args {}
}

###
# topic: 46af43b297df419610f117f2720c008fc9046d62
###
shed::class create ::shed::classes::project {
  
  meta set shed shed_class: project

  self method shed_class info {
    return project
  }
  method initialize {} {
    my graft project ::noop
  }
  ###
  # topic: 7fcc4adfb4a52e318f29ceb085aaaf89075ca978
  ###
  method exported_objects {} {
    set result [next]
    dict set result project [self]
    return $result
  }
  
  ###
  # topic: c892b057b7e3348e47c348e565b86f263e70f2ce
  ###
  method autoscan TOOL_ROOT {
    ###
    # Detect if this is a TEA project
    ###
    
    set version_detected {}
    set found 0
    if {[file exists $TOOL_ROOT/configure.ac]} {
      foreach rawline [::fileutil::grep AC_INIT [list [file join $TOOL_ROOT configure.ac]]] {
        set found [regexp {AC_INIT\(\s*\[([a-zA-Z0-9]+)\],\s*\[([.\d]+)\]\)} $rawline - pkgname pkgvers]
        if { $found } break
      }
    } elseif {[file exists $TOOL_ROOT/configure.in]} {
      foreach rawline [::fileutil::grep AC_INIT [list [file join $TOOL_ROOT configure.in]]] {
        set found [regexp {AC_INIT\(\s*\[([a-zA-Z0-9]+)\],\s*\[([.\d]+)\]\)} $rawline - pkgname pkgvers]
        if { $found } break
      }
    }
    if {$found} {
      my shed set class: tea
      my add [list shed_class: package name: $pkgname version: $pkgvers class: binary build: tea]
    }
    
    # No local help, auto detect
    if {[file exists [file join $TOOL_ROOT apps]]} {
      foreach file [glob -nocomplain [file join $TOOL_ROOT apps *]] {
        if {[file extension $file] in {{} .tcl}} {
          my scan $file {class: application}
        }
      }
    }
    foreach toppath {lib library tcl generic win macosx macos unix windows} {
      if {[file exists [file join $TOOL_ROOT $toppath]]} {
        my scan [file join $TOOL_ROOT $toppath] {class: source}
      }
    } 
    foreach toppath {cmodules modules lib library} {
      if {[file exists [file join $TOOL_ROOT $toppath]]} {
        # Tcllib style with a modules directory
        foreach path [glob -nocomplain [file join $TOOL_ROOT $toppath *]] {
          my scan $path {class: source}
        }
      }
    }  
  }
  
  ###
  # topic: 0954b7dd0d0f5c88635232ef8ead7996cea46ecc
  ###
  method Shed_Links {} {
  }
}

