###
# topic: 3a4de27ad8fc9bf0c33b26645d0e2c7051b8363d
# description: Class which represents a person or organization
###
shed::class create ::shed::classes::file {

  meta set shed shed_class: file
  meta set shed linktype: file

  self method scan {parentObj file {metadata {}}} {
    if {[file tail $file] eq "pkgIndex.tcl"} return
    if {[file type $file] ne "file"} return
    dict set current_product shed_class: file
    dict set current_product linktype: file
    dict set current_product name: [file tail $file]
    dict set current_product file: [::fileutil::relative $::TOOL_ROOT $file]

    dict set current_product format: [string trimleft [file extension $file] .]
    set current_product [dict rmerge $current_product $metadata]

    switch [file extension $file] {
      .tm -
      .tcl {
        dict set current_product format: tcl
        set current_product [dict rmerge $current_product [my tcl_filescan $file $current_product]]
      }
      .c {
        dict set current_product class: source
        dict set current_product format: c       
      }
      .cpp {
        dict set current_product class: source
        dict set current_product format: c++       
      }
      .m {
        dict set current_product class: source
        dict set current_product format: objective-c     
      }
      .zip {
        dict set current_product class: archive
        dict set current_product format: zip
      }
      .jpeg -
      .jpg {
        dict set current_product class: image
        dict set current_product format: jpeg
      }
      .bmp - .gif - .ico - .pcx - .png {
        dict set current_product class: image
      }
      .txt - .sql {
        dict set current_product class: data
        dict set current_product format: ascii
      }
      .csv  {
        dict set current_product class: data
        dict set current_product format: ascii
      }
      .shed {
        return 
      }
      default {
        set info [my tcl_filescan $file $current_product]
        if {[dict getnull $info package-require:] eq {} } return
        dict set current_product format: tcl
        set current_product [dict rmerge $current_product $info]
      }
    }
    dict set current_product file-sha1: [::sha1::sha1 -filename $file -hex]
    dict set current_product file-size: [file size $file]
    dict set current_product file-mtime: [clock format [file mtime $file] -format "%Y-%m-%d %H:%M:%S"]
    set newprod [$parentObj add $current_product]
    foreach uuid [$newprod link list package] {
      $parentObj link create [$parentObj <document> object $uuid] package
      $parentObj <project> link create [$parentObj <document> object $uuid] package
    }
    return $newprod
    
  }
  

  self method tcl_filescan {file {metadata {}}} {
    set current_product $metadata
    if {![dict exists $current_product class:]} {
      dict set current_product class: script
    }
    set meta_info [::shed::teacup_scan $file]
    set current_product [dict rmerge $current_product $meta_info]
    set pkginfo [::shed::pkg_scan_tcl $file]
    if {[llength $pkginfo]} {
      set current_package {}
      dict set current_package file: [file tail $file]
      foreach pkg $pkginfo {
        set keyword [string trimright [lindex $pkg 0] s]
        if {$keyword eq "provide"} {
          dict set current_package name: [lindex $pkg 1]
          dict set current_package version: [lindex $pkg 2]
          dict set current_product package-provide: [list [lindex $pkg 1] [lindex $pkg 2]]
          dict set current_product package/ [list $current_package]
        }
        if {$keyword eq "require"} {
          dict lappend current_product package-require: [lrange $pkg 1 end]
        }
      }
    }
    set requires [list {*}[dict getnull $current_product package-require:]  {*}[dict getnull $current_product require:] {*}[dict getnull $current_product requires:] ]
    dict set current_product package-require: [lsort -unique -dictionary $requires]
    if {[file exists [file rootname $file].shed]} {
      source [file rootname $file].shed
    }
    return $current_product
  }
  
  self method shed_class info {
    return file
  }
}