###
# topic: 22cb073fad9c409fa96b4147a20ec5514e268ca4
# description: Class which reperesents a callable project
###
shed::class create ::shed::classes::package {

  meta set shed shed_class: package
  meta set const parent-link: package
  meta set shed class: package
  ###
  # topic: ba85d9ff4abd5e2d63c72996cca459418b3990c9
  ###
  method identify {} {
    return [list [my shed get name:] [my shed get version:]]
  }

  ###
  # topic: c13383e10c01d0be84e4fa958566b6f8d0ba17ae
  ###
  method search_compare other {
    if {$other eq {}} {
      return -1
    }
    set myver [my shed get version:]
    set otver [$other shed get version:]
    return [package vcompare $otver $myver]
  }

  ###
  # topic: 6dd8e5416f33cd44a7bf72629730b86d40790e1e
  ###
  method search_match args {
    switch [llength $args] {
      1 {
        set query [lindex $args 0]
        if {![string match [lindex $query 0] [my shed get name:]]} {
          return 0
        }
        if {[llength $query]==1} {
          return 1
        }
        return [string match [lindex $query 1] [my shed get version:]]
      }
      2 {
        
        lassign $args qname qver
        if {![string match $qname [my shed get name:]]} {
          return 0
        }
        return [string match $qver [my shed get version:]]
      }
      default {
        error "Usage: search_match package ?version?"
      }
    }
    set query 
    my variable shed
    return [string match [lindex $args 0] $name]
  }
  
  self method shed_class info {
    return package
  }
  
  ###
  # topic: 0954b7dd0d0f5c88635232ef8ead7996cea46ecc
  ###
  method Shed_Links {} {
    if {[my organ superior] ne [my organ project]} {
      my <project> link create [self] package
    }
    set stype [my <superior> meta cget shed-type:]
    if {$stype in {application module}} {
      my shed set $stype: [my <superior> identify]
    } else {
      set module [my shed getnull module:]
        if {$module ne {}} {
        set mod [my <project> module object $module]
        $mod link create [self] package
      }
      set appname [my shed getnull application:]
      if {$appname ne {}} {
        set app [my <project> best $appname]
        $app link create [self] 
      }
    }
  }
}

