###
# topic: 86c73006031d2abcfd9662e343012252a4742256
# description: Class which represents a module of code
###
shed::class create ::shed::classes::module {

  meta set shed shed_class: module
  meta set shed linktype: module
  
  self method scan {parentObj path {metadata {}}} {
    if {[file type $path] ni {directory link}} {
      return {}
    }
    set recursive [string is true -strict [dict getnull $metadata recursive:]]
    set current_module $metadata
    dict unset current_module recursive:
    set modname [file tail $path]
    dict set current_module linktype: module
    dict set current_module name: $modname
    dict set current_module path: [::fileutil::relative $::TOOL_ROOT $path]
    set newobj [$parentObj add $current_module]
    if {[file exists [file join $path module.shed]]} {
      $newobj shed source [file join $path module.shed]
    } else {
      # We were getting some wicked infinite recursion
      # if nested modules had just the wrong file naming
      # convention
      foreach file [::fileutil::find $path] {
        if {[file type $file] ne "file"} continue
        $newobj scan $file {class: source}
      }
    }
    set modid [$newobj shed uuid]
    set products [$newobj link list]
    if {[llength $products]==0} {
      $newobj delete
      return {}
    }
    set provides {}
    set requires {}
    $parentObj <db> eval {select value from meta where field='package-provide' and entity in (select toid from link where fromid=:modid)} {
      ladd provides $value
    }
    $parentObj <db> eval {select value from meta where field='package-require' and entity in (select toid from link where fromid=:modid)} {
      ladd requires {*}$value
    }
    $newobj shed set package-require: [lsort -dictionary -unique $requires]
    $newobj shed set package-provide: [lsort -dictionary -unique $provides]
    $newobj shed store
    return $newobj
  }
  
  self method shed_class info {
    return file
  }
  
  method export_branch {resultvar} {
    upvar 1 $resultvar result
    set uuid [my shed uuid]
    if {[dict exists $result $uuid]} return
    my <db> eval {select * from entity where uuid=:uuid} {
      dict set result $uuid entity name: $name
      dict set result $uuid entity shed_class: $shed_class
      dict set result $uuid entity version: $version
    }
    my <db> eval {select * from meta where entity=:uuid} {
      if {[string match "file-*" $field]} continue
      dict set result $uuid meta [string trimright $field :]: $value
    }
    set rawlist [my <db> eval {select linktype,toid from link where fromid=:uuid and linktype!='file'}]
    if {[llength $rawlist]==0} return
    foreach {linktype toid} $rawlist {
      dict lappend linkdict $linktype/ $toid
      [my <document> object $toid] export_branch result
    }
    foreach {type list} $linkdict {
      dict set result $uuid $type $list
    }
  }
}

