###
# A toplevel document in the node tree
###
shed::class create ::shed::document {

  constructor script {
    my variable shed
    set shed [my meta getnull shed]
    set uuid [dict get $script uuid:]
    my shed set uuid: $uuid
    package require sqlite3
    set dbobj [namespace current]::DB
    sqlite3 $dbobj :memory:
    $dbobj eval [::shed::schema INDEX]    
    my graft db $dbobj
    my graft document [self]
    my register $uuid [self]
    my Shed_Script $script
    my initialize
  }

  method Child_link {uuid info} {}

  method child_uuid {info} {
    switch {[dict getnull $info shed_class:]} {
      project {
        return [::tool::uuid_generate TCL PROJECT [dict getnull $info name:] [dict getnull info version:]]
      }
      package {
        return [::tool::uuid_generate TCL PACKAGE [dict getnull $info name:] [dict getnull info version:]]
      }
    }
    return [::tool::uuid_generate]
  }

  method register {uuid obj} {
    my variable nodes uuids
    set nodes($uuid) $obj
    set uuids($obj) $uuid
  }
  
  ###
  # topic: 7420bec45f32ce0964554bb3a82b25c1e092b80d
  ###
  method unregister object {

    my variable nodes uuids
    # Register the destruction of an object
    if {[info exists uuids($object)]} {
      unset nodes($uuids($object))
    }
    unset uuids($object)
  }
  
  method object {uuid {create 0}} {
    set uuid [namespace tail $uuid]
    my variable nodes
    if {[info exists nodes($uuid)]} {
      set obj [info command $nodes($uuid)]
      if {$obj ne {}} {
        return $obj
      }
    }
    if {![my <db> exists {select uuid from entity where uuid=:uuid}]} {
      if {!$create} {
        error "Entity $uuid does not exist"
      }
    } else {
      set dat [dict merge [my <db> eval {select field,value from meta where entity=:uuid}] [my <db> eval {select 'uuid:',uuid,'name:',name,'version:',version,'shed_class:',shed_class from entity where uuid=:uuid}]]
    }
    set parent [my <db> one {select fromid from link where toid=:uuid}]
    if {$parent ne {}} {
      set parent [my object $parent 1]
    } else {
      set parent [self]
    }
    ::shed::object create [namespace current]::$uuid $parent $dat
    return [namespace current]::$uuid
  }

  ###
  # topic: 7fcc4adfb4a52e318f29ceb085aaaf89075ca978
  ###
  method exported_objects {} {
    dict set result db [my organ db]
    dict set result document [self]
    dict set result superior [self]
    return $result
  }
  
  ###
  # topic: fab414738052492351a77c538130121282622de9
  ###
  method export {} {
    my variable nodes
    set result {}
    # Start with the parent-less nodes
    my <db> eval {select uuid from entity where uuid not in (select toid from link)} {
      set obj [my object $uuid]
      $obj export_branch result
    }
    return $result
  }
}