###
#
###
::oo::dialect::create ::shed ::tool
::namespace eval ::shed::class {}

###
# topic: beba0f78806352f93bc7b0b8b451d17b3c95a2c5
# description:
#    Class which builds its objects from a
#    TOOL description script
###

::shed::define ::shed::object {
  
  meta set const parent-link: generic
  meta set shed class: generic
  meta set shed shed_class: generic

  self method find uuid {
    set uuid [namespace tail $uuid]
    if {[info command ::shed::objects::$uuid] ne {}} {
      return ::shed::objects::$uuid
    }
    if {![::shed::db exists {select uuid from entity where uuid=:uuid}]} {
      error "Entity $uuid does not exist"
    }
    set dat [dict merge [::shed::db eval {select field,value from meta where entity=:uuid}] [::shed::db eval {select 'uuid:',uuid,'name:',name,'version:',version,'shed_class:',shed_class from entity where uuid=:uuid}]]
    set parent [::shed::db one {select fromid from link where toid=:uuid and linktype in ('project','module','application')}]
    if {$parent ne {}} {
      set parent [my uuid $parent]
    }
    ::shed::object create ::shed::objects::$uuid $parent $dat
    return ::shed::objects::$uuid
  }
  
  self method shed_class info {
    foreach field {shed_class: linktype: class:} {
      if {[dict exists $info $field]} {
        return [dict get $info $field]
      }
    }
    return [my meta getnull shed shed_class:]
  }
  
  constructor {superiorObj {script {}}} {
    my variable shed
    set shed [my meta getnull shed]
    set uuid [dict get $script uuid:]
    my shed set uuid: $uuid
    my graft db ::shed::db
    my graft superior $superiorObj
    my graft {*}[my <superior> exported_objects]
    
    my <document> register $uuid [self]
  
    my Shed_Script $script
    my initialize
  }

  destructor {
    catch {my <document> unregister [self]}
  }
  
  method initialize {} {}

  method delete {} {
    set uuid [my shed uuid]
    my <db> eval {
BEGIN TRANSACTION;
delete from link where toid=:uuid;
delete from link where fromid=:uuid;
delete from meta where entity=:uuid;
delete from entity where uuid=:uuid;
COMMIT;
}
    my destroy
  }
    
  dictobj shed shed {
    uuid {
      if {[llength $args]==0} {
        return [dict getnull $shed uuid:]
      }
      set newuuid [lindex $args 0]
      set oldid [dict getnull $shed uuid:]
      if {$oldid ne {}} {
        dict set shed uuid: $newuuid
        my <db> transaction {
update entity set uuid=:newuuid where uuid=:olduuid;
-- Should be redundant
update link set toid=:newuuid where toid=:olduuid;
update link set fromid=:newuuid where fromid=:olduuid;
update meta set entity=:newuuid where entity=:olduuid;
        }
      }
      my <document> unregister [self]
      my <document> register [self] $newuuid
    }
    class {
      if {[llength $args]==0} {
        return [dict getnull $shed shed_class:]
      }
      set newclass [lindex $args 0]
      set uuid [my shed uuid]
      dict set shed shed_class: $newclass
      my <db> transaction {update entity set shed_class=:newclass where uuid=:uuid}
    }
    source {
      set dir [file dirname [file normalize [lindex $args 0]]]
      source [lindex $args 0]
    }
    import {
      my Shed_Script [lindex $args 0]
    }
    retrieve {
      my Shed_Retrieve
    }
    store {
      my Shed_Store
    }
    export {
      return [my export]
    }
  }
  
  method Child_class info {
    foreach class [info command ::shed::classes::*] {
      if {[dict exist $info shed_class:]} {
        if {[$class meta getnull shed shed_class:] eq [dict getnull $info shed_class:]} {
          return $class
        }
      }
      if {[dict exist $info linktype:]} {
        if {[$class meta getnull shed shed_class:] eq [dict getnull $info linktype:]} {
          return $class
        }
      }
    }
    return ::shed::object
  }
  
  method Child_link {obj info} {
    set uuid [$obj shed uuid]
    if {[dict exists $info linktype:]} {
      set linktype [dict get $info linktype:]
    } else {
      set linktype [$obj shed class]
    }
    my link create $obj $linktype
  }
  
  method add {info} {
    set newclass [my Child_class $info]
    if {![dict exists $info uuid:]} {
      set uuid [my child_uuid $info]
      dict set info uuid: $uuid
    }
    set obj [$newclass new [self] $info]
    my Child_link $obj $info
    return $obj
  }
  
  method child_uuid {info} {
    set myuuid [my shed uuid]
    switch {[dict getnull $info shed_class:]} {
      project {
        return [::tool::uuid_generate TCL PROJECT [dict getnull $info name:] [dict getnull info version:]]
      }
      package {
        return [::tool::uuid_generate TCL PACKAGE [dict getnull $info name:] [dict getnull info version:]]
      }
    }
    return [::tool::uuid_generate $myuuid [dict getnull $info linktype:] [dict getnull $info name:] [dict getnull info version:]]
  }
  
  ###
  # topic: 0e7b87d2da169ce523f3cd53b419553a7e6d36af
  ###
  method exported_objects {} {
    set result {}
    foreach {item obj} [my organ] {
      # Never send an immediate superior as a graft target
      if {$item eq "superior"} continue
      lappend result $item $obj
    }
    return $result
  }

  ###
  # topic: b89a1efb7d6fd3b2ef168ee4bf1dd94a0298b687
  ###
  method identify {} {
    return [my shed get name:]
  }

  method link {method args} {
    switch $method {
      create {
        lassign $args object linktype
        set myuuid [my shed uuid]
        set objuuid [$object shed uuid]
        my <db> eval {insert or ignore into link (fromid,toid,linktype) VALUES (:myuuid,:objuuid,:linktype);}
      }
      remove {
        set myuuid [my shed uuid]
        set object [lindex $args 0]
        set objuuid [$object shed uuid]
        if {[llength $args]==1} {
          my <db> eval {delete from link where fromid=:myuuid AND toid=:objuuid;}          
        } else {
          foreach linktype $args {            
            my <db> eval {delete from link where fromid=:myuuid AND toid=:objuuid AND linktype=:linktype;}
          }
        }
      }
      list {
        set myuuid [my shed uuid]
        if {[llength $args]==0} {
          return [my <db> eval {select linktype,toid from link where fromid=:myuuid order by linktype}]
        }
        if {[llength $args]==1} {
          set linktype [lindex $args 0]
          return [my <db> eval {select toid from link where fromid=:myuuid and linktype=:linktype}]
        }
        set result {}
        foreach linktype $args {
          dict set result $linktype [my <db> eval {select toid from link where fromid=:myuuid and linktype=:linktype}]
        }
        return $result
      }
      list-names {
        set myuuid [my shed uuid]
        set result {}
        if {[llength $args]==0} {
          my <db> eval {select linktype,toid from link where fromid=:myuuid order by linktype} {
            lappend result $linktype [[::shed::object uuid $toid] identify]
          }
          return [lsort -dictionary -stride 2 $result]
        }
        if {[llength $args]==1} {
          set linktype [lindex $args 0]
          my <db> eval {select toid from link where fromid=:myuuid and linktype=:linktype} {
            lappend result [[::shed::object uuid $toid] identify]
          }
          return [lsort -dictionary $result]
        }
        set result {}
        foreach linktype $args {
          lappend result $linktype
          set thisrow {}
          my <db> eval {select toid from link where fromid=:myuuid and linktype=:linktype} {
            lappend thisrow [[::shed::object uuid $toid] identify]
          }
          lappend result [lsort -dictionary $thisrow]
        }
        return $result
      }
      references {
        set myuuid [my shed uuid]
        if {[llength $args]==0} {
          return [my <db> eval {select linktype,fromid from link where toid=:myuuid order by linktype}]
        }
        if {[llength $args]==1} {
          set linktype [lindex $args 0]
          return [my <db> eval {select fromid from link where toid=:myuuid and linktype=:linktype}]
        }
        set result {}
        foreach linktype $args {
          dict set result $linktype [my <db> eval {select fromid from link where toid=:myuuid and linktype=:linktype}]
        }
        return $result
      }
    }
  }

  ###
  # topic: b1bc5be296390a59c15cefd574f88ff26e93d99b
  ###
  method search_compare object {
    if {$object eq {}} {
      return -1
    }
    my variable shed
    set name [dict get $shed name:]
    return [string compare [$object shed get name:] $name]
  }

  ###
  # topic: 1e136ea6b937802aff24c5a4b1bdd71ae68b77e4
  ###
  method search_match args {
    my variable shed
    set name [dict get $shed name:]
    return [string match [lindex $args 0] $name]
  }

  method export_branch {resultvar} {
    upvar 1 $resultvar result
    set uuid [my shed uuid]
    if {[dict exists $result $uuid]} return
    my <db> eval {select * from entity where uuid=:uuid} {
      dict set result $uuid entity name: $name
      dict set result $uuid entity shed_class: $shed_class
      dict set result $uuid entity version: $version
    }
    my <db> eval {select * from meta where entity=:uuid} {
      if {[string match "file-*" $field]} continue
      dict set result $uuid meta [string trimright $field :]: $value
    }
    set rawlist [my <db> eval {select linktype,toid from link where fromid=:uuid}]
    if {[llength $rawlist]==0} return
    foreach {linktype toid} $rawlist {
      dict lappend linkdict $linktype/ $toid
      [my <document> object $toid] export_branch result
    }
    foreach {type list} $linkdict {
      dict set result $uuid $type $list
    }    
  }
  
  method scan {path {metainfo {}}} {
    if {![file exists $path]} {
      return
    }
    switch [file type $path] {
      directory -
      link {
        return [::shed::classes::module scan [self] $path [dict merge $metainfo {class: source}]]
      }
      file {
        return [::shed::classes::file scan [self] $path $metainfo]
      }
    }
  }
  
  ###
  # topic: 355affb305f37ac691565b0604fec10dfc3698fe
  ###
  method Shed_Links {} {}

  ###
  # Instantiate this object from the shed collective
  ###
  method Shed_Retrieve {} {}

  ###
  # topic: 9d0bc4fee90f7ac8dff74961d0554e9a01c8ca2c
  # description: Build an object's configuration from a SHED script
  ###
  method Shed_Script script {
    foreach {field value} $script {
      if {[string index $field end] eq "/"} {
        continue
      }
      my shed set $field $value
    }
    my Shed_Store
    foreach {field value} $script {
      if {[string index $field end] ne "/"} {
        continue
      }
      set type [::string trimright $field /]
      foreach item $value {
        dict set item linktype: $type
        my add $item
      }
    }
    my Shed_Links
  }

  ###
  # File this object into the shed collective
  ###
  method Shed_Store {} {
    my <db> transaction {
      set uuid [my shed uuid]
      set name [my shed get name:]
      set shed_class [my shed getnull shed_class:]
      if {$shed_class eq {}} {
        set shed_class [my shed getnull linktype:]
      }
      set version [my shed getnull version:]
      if {$version eq {}} {
        unset version
      }
      if {![my <db> exists {select uuid from entity where uuid=:uuid}]} {
        my <db> eval {insert into entity (uuid,shed_class,name,version) VALUES (:uuid,:shed_class,:name,:version);}
      } else {
        my <db> eval {update entity set shed_class=:shed_class,name=:name,version=:version where uuid=:uuid};
      }
      
      foreach {field value} [my shed dump] {
        set field [string trimright $field :]
        if {$field in {uuid shed_class name version linktype}} continue
        my <db> eval "insert or replace into meta (entity,field,value) VALUES (:uuid,:field,:value);"
      }
    }
  }

}

