###
# index.tcl
#
# This file loads the rest of the odie package
#
# Copyright (c) 2012 Sean Woods
#
# See the file "license.terms" for information on usage and redistribution of
# this file, and for a DISCLAIMER OF ALL WARRANTIES.
###

###
# This version is always higher than the one embedded with
# the odie core to better exploit the C accellerated tools
###
package require listutil 1.8
package require tao

set odie_path [file dirname [info script]]
foreach file {
  global.tcl
  stack.tcl
  logicset.tcl
  queue.tcl
} {
  source [file join $odie_path $file]
}
###
# Load the C accellerated modules
###
catch {package require odielib}

package provide odie 0.2
