namespace eval ::gort {}

package require platform

if {$::tcl_platform(platform) eq "windows"} {
  set ::gort(os) windows
  set ::gort(prefix) [file join $::env(HOME)]
} else {
  set ::gort(os) [lindex [split [::platform::generic] -] 0]
}

proc ::gort::_executable name {
  # Ignore any parameters
  set name [lindex $name 0]
  if {$name eq ""} {
    # The empty string is never a valid executable
    return {}
  }
  if {$::gort(os) eq "windows"} {
    set path [split $::env(PATH) {;}]
    foreach p {
      c:/tcl/bin
      c:/MinGw/msys/1.0/bin
      c:/MinGw/msys/1.0/usr/bin
    } {
      if {[file exists $p]} {
        lappend path [file nativename $p]
      }
    }
    set exts {{} .EXE}
  } else {
    set path [split $::env(PATH) {:}]
    set exts {{}}
  }
  foreach p $path {
    foreach ext $exts {
      set exec [file join $p $name$ext]
      if {[file executable $exec]} {
        return [file normalize $exec]
      }
    }
  }
  return {}
}

proc ::gort::find-EXE {FLAG args} {
  set result {}
  if {[llength $args] eq 0} { 
    set FLAG [string toupper $FLAG]
    set args [string tolower $FLAG]
  }
  if {[info exists ::env($FLAG)]} {
    if {$::env($FLAG) ne {}} {
      return $::env($FLAG)
    }
  }
  if {[info exists ::gort($FLAG)]} {
    if {$::gort($FLAG) ne {}} {
      return $::gort($FLAG)
    }
  }
  return [find-executable {*}$args]
}

proc ::gort::find-executable args {
  set required 0
  if {[lindex $args 0] eq "-required"} {
    set args [lrange $args 1 end]
    incr required
  }
  foreach name $args {
    set exec [_executable $name]
    if {$exec ne {}} {
      return $exec
    }
  }
  if {$required} {
    if {[llength $args] == 1} {
      error "failed to find: [join $args]"
    } else {
      error "failed to find one of: [join $args]"
    }
  }
  return ""
}

proc ::gort::user_data_root {app} {
  if {$::tcl_platform(platform) eq "windows"} {
    return [file join $::env(APPDATA) $app]
  }
  package require platform
  set os [lindex [split [::platform::generic] -] 0]
  if {$os eq "macosx"} {
    return  [file join $::env(HOME) Library {Application Support} $app]
  }
  return [file join $::env(HOME) .$app]
}

###
# topic: 59e74136f50d760afe4d2508ef411e190a9c4cdc
###
proc ::copy_path {src dest} {
  set stack {}
  set result {}
  set src [file normalize $src]
  set dest [file normalize $dest]
  set srcpathidx [string length $src]
  if {[file isdirectory $src]} {
    lappend stack $src
  } else {
    lappend result $src
  }
  while {[llength $stack]} {
    set path [lindex $stack 0]
    set stack [lrange $stack 1 end]
    foreach file [glob -nocomplain $path/*] {
      if {[file isdirectory $file]} {
        set stack [linsert $stack 0 $file]
      } else {
        lappend result $file
      }
    }
  }
  file mkdir $dest
  foreach file $result {
    set newpath $dest[string range $file $srcpathidx end]
    if {![file exists [file dirname $newpath]]} {
      file mkdir [file dirname $newpath]
    }
    file copy -force $file $newpath
  }
}

proc ::gort::fossil_db pkg {
  set pathlist {}
  set extlist {.fossil .fos .fsl}
  foreach path {
    {[list $::gort(download)] fossil}
    {[list $::gort(download)]}
    ~/download
    ~/odie/download
  } {
    foreach ext $extlist {
      set fname [file join {*}[subst $path] $pkg$ext]
      if {[file exists $fname]} {
        return $fname
      }
    }
  }
  file mkdir [file join $::gort(download) fossil]
  return [file join $::gort(download) fossil $pkg.fos]
}


proc ::gort::project_source {project existsvar} {
  upvar 1 $existsvar exists
  set exists 0
  set pathlist {
    {[list $::gort(sandbox)]}
    {$::gort(home) ..}
    {~/gort/sandbox}  
  }
  set chkoutext {
    .fslckout
    _FOSSIL_
    .download
  }
  foreach path $pathlist {
    set projdir [file join {*}[subst $path] $project]
    foreach ext $chkoutext {
      set cfile [file join $projdir $ext]
      if {[file exists $cfile]} {
        set exists 1
        return $projdir
      }
    }
  }
  # Default to the directory above
  return [file join $::gort(sandbox) $project]
}

###
# topic: b6d814b51c568dd177f4335fbd9b3a5b2c9518a7
###
proc ::doexec args {
  exec {*}$args >&@ stdout
}


