###
# Driver for generic Tcl based make systems
###

###
# topic: bd838ab187095e96d6f1343e5920a0ee35cb1c83
# title: Driver for Andreus Kupries Kettle system
###
gort::class create ::gort::toolset.kettle {
  superclass gort::toolset

  ###
  # topic: 50e4bf5f8341384a01dad2b85a45d9f4e688b286
  ###
  method make-install {path {dpath {}}} {
    my kettle reinstall --prefix [::toolset define-get prefix]
  }

  ###
  # topic: e8a8fcac0156a72f5a12a6d359813011ed1928d0
  ###
  method kettle {path args} {
    set kettle [file join $::gort(sandbox) kettle kettle]
    #set mycritcl [file join $::gort(sandbox) critcl main.tcl]
    # We need to lead the witness
    #set opts [list --with-critcl3 ${mycritcl}]
    #set opts [list --with-critcl3 [list $::gort(tclsh) ${mycritcl}]]
    set opts {}
    doexec $::gort(tclsh) $kettle -f [file join $path build.tcl] {*}$args {*}$opts
  }

  ###
  # topic: 840fa906f82b91bafe6f05c7a96e1d3acdae9dcf
  ###
  method make-all path {
    if {[my recipe-present]} {return 1}
    if {[my recipe-skip]} {return 1}
    my <distribution> download
    my recipe-detect-properties 1
    my build-clean
    return 0
  }
}

###
# topic: a0104cd0f37e60fea1d5b4e4d1e4f8f70ec77b1b
###
gort::class create ::gort::toolset.kettle_classic {
  superclass gort::toolset.kettle

  ###
  # topic: ebda815a4365939d48b7e944fa5c3a2989045b5a
  ###
  method make-install {} {
    cd [my path-build]
    set pkgname [my define getnull package_name]
    set dpath [file join [::toolset define-get libdir] $pkgname]
    if {[file exists $dpath]} {
      file delete -force $dpath
    }
    my kettle install $dpath
  }
}

gort::class create ::gort::toolset.sak {
  superclass ::gort::toolset
}
