###
# Tools for CC/GCC Environments
###
gort::class create ::gort::toolset.make {
  superclass ::gort::toolset

  self method match info {
    if { {gcc} ni [dict getnull $info toolset]} {
      return 0
    }
    if {[dict exists $info make]} {
      set try [dict get $info make]
    } else {
      set try make
    }
    set exec [::gort::find-EXE MAKE {*}$try]    
    if {$exec eq ""} {
      return 0
    }
    return 1
  }
  
  method MakeExec {} {
    my variable makeexe
    if {[info exists makeexe]} {
      return $makeexe
    }
    set try [my define-get MAKE make]
    set exec [::gort::find-EXE MAKE {*}$try]    
    if {$exec eq ""} {
      error "Could not find make on this system"
      return 0
    }
    set makeexe $exec
  }


  method make-is-configured {path_build} {
    return [file exists [file join $path_build Makefile]]
  }


  method make-all path {
    set cwd [pwd]
    cd $path
    doexec [my MakeExec] all
    cd $cwd
  }
  
  method make-clean path {
    if {![file exists [file join $path Makefile]]} return
    set cwd [pwd]
    cd $path
    doexec [my MakeExec] clean
    cd $cwd
  }

  method make-distclean path {
    if {![file exists [file join $path Makefile]]} return
    set cwd [pwd]
    cd $path
    doexec [my MakeExec] distclean
    cd $cwd
  }

  method make-install {path {dpath {}}} {
    set cwd [pwd]
    cd $path
    if {$dpath eq {}} {
      doexec [my MakeExec] install
    } else {
      doexec [my MakeExec] install DESTDIR=$dpath
    }
    cd $cwd
  }
}