gort::class create ::gort::toolset.gnumake {
  superclass ::gort::toolset.gcc

  self method match info {
    if {"gnumake" ni [dict getnull $info toolset]} {
      return 0
    }
    return 1
  }

  method configure {path args} {
    error "Called the wrong configure method"
    set shell [my define-get SHELL sh]
    cd $path
    puts "prefix: [my define-get prefix]"
    puts "exec_prefix: [my define-get exec_prefix]"
    puts "bindir: [my define-get bindir]"
    puts "libdir: [my define-get libdir]"

    ::doexec $shell ./configure \
      --prefix=[my define-get prefix] \
      --exec_prefix=[my define-get exec_prefix] \
      --bindir=[my define-get bindir] \
      --libdir=[my define-get libdir] {*}$args
  }
}