###
# topic: f46f688e26b3d6d6386eb4a777ea14162d7733f2
# A placeholder for when we have no toolset.
###
gort::class create ::gort::toolset {
  superclass ::tool::organelle ::gort::platform
  
  ###
  # Select the toolset for this environment
  # At present toolset autoconf is supported
  ###
  method select {} {
    switch [my define cget toolset] {
      smake {
        return ::gort::toolset/smake
      }
      cmake {
        return ::gort::toolset/cmake
      }
      autosetup {
        return ::gort::toolset/autosetup
      }
      tea -
      autoconf {
        return ::gort::toolset/autoconf
      }
      tclmake {
        return ::gort::toolset/tclmake
      }
    }
    return ::gort::toolset
  }
  
  method detect-metadata {spath lpath} {
  }
  
  ###
  # topic: f3ffeba5470a4b95d9b2fef7c6d834a7d8052d57
  ###
  method initialize {} {
    set target [my define getnull target]
    if {$target in {{} local}} {
      my target local
    } else {
      my target $target      
    }
    source [file join ${::gort::home} toolset script_toolset.tcl]
  }
  method make-configure {path_source path_build args} {}
  
  method make-is-configured build_path {
    return 1
  }
  
  method make-clean buildpath {}
  
  method target args {
    if {[llength $args]==0} {
      return [my _platformGet platform]
    }
    foreach varname {platform define tcl tk teapot odie} {
      my variable $varname
      array unset $varname *
    }
    set newtarget [lindex $args 0]
    if {$newtarget in {"local" {}}} {
      set newtarget [::gort::platform_normalize [::platform::identify]]
      my define set prefix $::gort(prefix)
    } else {
      set newtarget [::gort::platform_normalize $newtarget]
      my define set prefix [file join $::gort(prefix) target $newtarget]
    }
    if {$::env(GORT_DEBUG)} {
      puts [list TARGET [lindex $args 0] $newtarget]
    }
    # Building a cross compiled environment
    my define set target $newtarget
  }
}
