gort::class create ::gort::toolset/cmake {
  superclass ::gort::toolset.make ::gort::toolset

  self method match info {
    if {"cmake" ni [dict getnull $info toolset]} {
      return 0
    }
    if {[dict exists $info cmake]} {
      set try [dict get $info cmake]
    } else {
      lappend try cmake
    }
    set exec [::gort::find-executable {*}$try]    
    if {$exec eq ""} {
      error "Could not find cmake on this system"
      return 0
    }
    return 1
  }
  
  method CmakeExec {} {
    my variable cmake
    if {[info exists cmake]} {
      return $cmake
    }
    set try [my define-get CMAKE cmake]
    set exec [::gort::find-executable {*}$try]    
    if {$exec eq ""} {
      error "Could not find cmake on this system"
      return 0
    }
    set cmake $exec
  }
  
  method cmake args {
    puts [list CMAKE $args]
    doexec [my CmakeExec] {*}$args
  }
  
  method make-configure {path_source path_build args} {
    set cwd [pwd]
    file mkdir $path_build
    cd $path_build
    set prefix [my define-get prefix]
    my cmake  -DCMAKE_INSTALL_PREFIX=[my define-get prefix] \
      --prefix=[my define-get prefix] \
      --exec_prefix=[my define-get exec_prefix] \
      --bindir=[my define-get bindir] \
      --libdir=[my define-get libdir] \
      --includedir=[file join $prefix include] $path_source
  }
  
  method make-all {buildpath} {
    cd $buildpath
    my cmake .
    doexec make all
  }

}