gort::class create ::gort::toolset/autosetup {
  superclass ::gort::toolset ::gort::toolset.make

  self method match info {
    puts [list MATCH [self] $info]
    if {"autosetup" ni [dict getnull $info toolset]} {
      return 0
    }
    return 1
  }
  
  method make-configure {path_source path_build args} {
    set cwd [pwd]
    set tclsh $::gort(tclsh)
    if {![file exists [file join $path_source auto.def]]} {
      error "Autosetup auto.def file not found"
    }
    file mkdir $path_build
    cd $path_build
    if {$path_build ne $path_source} {
      set env(WRAPPER) [list $tclsh [file join $path_source autosetup autosetup]]
      doexec $tclsh [file join $path_source autosetup autosetup] --conf=[file join $path_source auto.def] --prefix=[my define get prefix] {*}$args
    } else {
      doexec $tclsh [file join $path_source autosetup autosetup] --prefix=[my define get prefix] 
    }
    cd $cwd
  }
}