gort::class create ::gort::toolset/autoconf {
  superclass ::gort::toolset ::gort::toolset.make

  self method match info {
    if {"autoconf" in [dict getnull $info toolset]} {
      return 1
    }
    if {"autoconfigure" in [dict getnull $info toolset]} {
      return 1
    }
    return 0
  }
  
  method detect-metadata {spath lpath} {
    # Pull data from live, of possible
    set result {}
    if {[file exists [file join $spath gort.rc]]} {
      return [::codebale::read_rc_file [file join $spath gort.rc]]
    }
    ###
    # Detect package name and/or version
    ###
    set version_detected {}
    set found 0
    if {[file exists $spath/configure.ac]} {
      foreach rawline [::fileutil::grep AC_INIT [list [file join $spath configure.ac]]] {
        set found [regexp {AC_INIT\(\s*\[([a-zA-Z0-9]+)\],\s*\[([.\d]+)\]\)} $rawline - pkgname pkgvers]
        if { $found } break
      }
    } elseif {[file exists $spath/configure.in]} {
      foreach rawline [::fileutil::grep AC_INIT [list [file join $spath configure.in]]] {
        set found [regexp {AC_INIT\(\s*\[([a-zA-Z0-9]+)\],\s*\[([.\d]+)\]\)} $rawline - pkgname pkgvers]
        if { $found } break
      }
    }
    if {!$found} {
      # Could not autodetect the package version from configure.in
      # fall back to the static data in the recipe
      return {}
    }
    dict set result package_name $pkgname
    dict set result package_version $pkgvers
    dict set result package_lib_file [my tcl-shlib-name ${pkgname} ${pkgvers}]
    dict set result install_path [file join ${pkgname}${pkgvers}]
    return $result
  }
  
  method find-autoconf {} {
    my variable autoconf
    if {[info exists autconf]} {
      return $autoconf
    }
    lappend try autoconf
    set exec [::gort::find-EXE AUTOCONF {*}$try]    
    if {$exec eq ""} {
      error "Could not find autoconf on this system"
    }
    set autoconf $exec
    return $exec
  }
  
  method make-configure {path_source path_build args} {
    set cwd [pwd]
    set shell [::gort::find-EXE SHELL sh bash ksh]
    if {![file exists [file join $path_source configure]]} {
      cd $path_source
      if {[file exists autogen.sh]} {
        doexec $shell autogen.sh
      } elseif {[file exists configure.ac]} {
        set autoexe [my find-autoconf]
        ::doexec $autoexe
      } elseif {[file exists configure.in]} {
        set autoexe [my find-autoconf]
        ::doexec $autoexe
      } else {
        error "No configure file, and no autogen scripts"
      }
    }
    if {![file exist $path_build]} {
      file mkdir $path_build
    }
    cd $path_build
    ::doexec $shell [file join $path_source configure] \
      --prefix=[my define cget prefix] \
      --exec_prefix=[my define cget exec_prefix] \
      --bindir=[my define cget bindir] \
      --libdir=[my define cget libdir] \
      --datadir=[my define cget datadir] \
      --includedir=[my define cget includedir] \
      {*}$args
    cd $cwd
  }

  method force-configure {path args} {
    set cwd [pwd]
    cd $path
    if {[file exists [file join $path configure.in]]} {
      set autoexe [my find-autoconf]
      ::doexec $autoexe
    }
    set shell [my define-get SHELL sh]
    ::doexec $shell ./configure \
      --prefix=[my define-get prefix] \
      --exec_prefix=[my define-get exec_prefix] \
      --bindir=[my define-get bindir] \
      --libdir=[my define-get libdir] {*}$args
    cd $cwd
  }
}

