###
# Generic initialization for toolsets
###
###
# Script to perform when the target changes
###
###
# This script is evaluated within the emerging toolset object
###
my variable define platform tcl tk odie teapot

my teapot set cpu generic
my teapot set os  generic

my teapot set profile [my define cget profile gort-[my tcl get version]]
set arch [my define-get target [::localtool teapot platform]]
set arch_work [split $arch -]
set arch_os [join [lrange $arch_work 0 end-1] -]
set arch_cpu [lindex $arch_work end]

my platform set os $arch_os
my platform set cpu $arch_cpu
my platform set system $arch
set class [lindex [::oo::meta::search platform platform $arch] 0]
if {$class ne {}} {
  foreach array {platform tcl tk teapot define} {
    my $array branchset [$class meta getnull $array]
  }
}

set prefix [my define getnull prefix]
if {$prefix eq {}} {
  set prefix [::localtool tcl cget prefix]
}
set exec_prefix [my define getnull exec_prefix]
if {$exec_prefix eq {}} {
  set exec_prefix $prefix
}

set target [my define getnull target]
if {$target in {{} local}} {
  set build local
} else {
  set build $target
}
my define set prefix $prefix
my define set exec_prefix $exec_prefix

foreach {name defpath} {
  datadir         share
  sysconfdir      etc
  sharedstatedir  com
  localstatedir   var
  infodir         {share info}
  mandir          {share man}
  includedir      include
} {
  my define set $name [file join $prefix {*}$defpath]
}

foreach {name defpath} {
  bindir      bin
  sbindir     sbin
  libexecdir  libexec
  libdir      lib
} {
  my define set $name [file join $exec_prefix {*}$defpath]
}

my define set SHELL [::gort::find-EXE SHELL sh bash ksh]]

