###
# Burn-in script for a new Gort installation
###

set ::gort(settings) [::gort::user_data_root gort]

namespace eval ::gort {} {}

set ::gort::config_options {
  prefix {
    type: directory
    description: {Gort install prefix}
    detect: {[file join $::env(HOME) tcl]}
  }
  settings {
    type:        directory
    description: {Where Gort saves its settings}
    detect:     {[::gort::user_data_root gort]}
    readonly:   1
  }
  sandbox {
    type:        directory
    description: {Where gort will unpack source code and perform builds}
    detect:     {[file join $::gort(prefix) sandbox]}
  }
  download {
    type:        directory
    description: {Where gort will download source repositories and archives}
    detect:      {[file join $::gort(prefix) download]}
  }
  fossil {
    type:        executable
    description: {Local Fossil Executable}
    detect:     {[::gort::find-EXE FOSSIL fossil]}
  }
  git {
    type:        executable
    description: {Local Git Executable}
    detect:      {[::gort::find-EXE GIT git]}
    optional:    1
  }
  shell {
    type:        executable
    description: {Local Shell/Bash}
    detect:      {[::gort::find-EXE SHELL sh bash ksh]}
  }
  make {
    type:        executable
    description: {Local GNUMake}
    detect:      {[::gort::find-EXE MAKE make]}
  }
  teapot {
    type:        directory
    description: {Where gort will download and store teapot modules}
    detect:      {[file join $::gort(prefix) teapot]}
  }
  mirror_url {
    type:        url
    description: {Default website to search for fossil based projects}
    default:     http://fossil.etoyoc.com/fossil
  }
  recipes {
    type:        directory
    description: {Location where gort stores recipes}
    detect:      {[file join $::gort(home) recipes]}
  }
}

set ::gort::flag_options {
  static {
    type: boolean
    description: {Build static versions of libraries}
    default:      0
  }
  target {
    type:         string
    description:  {Which platform is gort targetting (default: the local platform)}
    default:      {local}
  }
  debug {
    type: boolean
    description: {Enable additional debugging info}
    default:      0
  }
}

proc ::gort::config_check {} {
  set changed 0
  ###
  # Add/remove/fix configuration settings
  ###
  foreach {item info} $::gort::flag_options {
    #if {[info exists ::gort($item)] && [string length $::gort($item)]} continue
    set envflag GORT_[string toupper $item]
    if {![info exists ::env($envflag)]} {
      set ::env($envflag) [dict getnull $info default:]
    }
    set ::gort($item) $::env($envflag)
  }
  foreach {item info} $::gort::config_options {
    if {[info exists ::gort($item)] && [string length $::gort($item)]} continue
    set changed 1
    if {[dict exists $info detect:]} {
      set ::gort($item) [subst [dict getnull $info detect:]]
    } else {
      set ::gort($item) [dict getnull $info default:]        
    }
    puts -nonewline "$item \[$::gort($item)\] :"
    flush stdout
    set reply [gets stdin]
    if {$reply ne {}} {
       set ::gort($item) $reply
    }
  }
  if {$changed} {
    config_save
  }
}

proc ::gort::config_detect {} {
  package require platform
  catch {
    package require gort
    array set ::odie [::localtool odie]
    array set ::profile_tcl [::localtool profile_tcl]
    array set ::profile_tk [::localtool profile_tk]
  }
  ::gort::config_check
}

proc ::gort::config_save {} {
  file mkdir $::gort(settings)
  set fout [open [file join $::gort(settings) gort.rc] w]
  foreach arrname {
    gort
    odie
    profile_tcl
    profile_tk
  } {
    puts $fout "array set ::${arrname} \{"
    foreach {var val} [lsort -dictionary -stride 2 [array get ::${arrname}]] {
      puts $fout "  [list $var $val]"
    }
    puts $fout "\}"
  }
  close $fout
}

###
# Put together some meaningful defaults
###
set ::gort(metapath) $::gort(settings)
if {[file exists [file join $::gort(settings) gort.rc]]} {
  ###
  # If we have a local setup, use it
  ###
  source [file join $::gort(settings) gort.rc]
} else {
  ###
  # Do our own setup
  ###
  ::gort::config_detect
  ::gort::config_save
}
###
# Add missing settings or fix
# corrupted one
###
::gort::config_check

catch {
set ::shed::dbfile [file join $::gort(metapath) shed.sqlite]
::shed::open_db $::shed::dbfile
}
package provide gort::settings 1.0
