###
# topic: 490e228e2ed539e62c82386e4cbcead8d5fa4ab9
# description: Grab extensions from the teapot
###
gort::class create ::gort::recipe.teapot {
  superclass gort::recipe gort::recipe.tclpkg

  ###
  # topic: c50575cf4278eb6223d50bc2152fd83c54e9eb96
  ###
  method recipe-install {} {
    set os  [my <toolset> teapot get os]
    set cpu [my <toolset> teapot get cpu]
    ::teapotclient::download_extensions [my <toolset> define-get libdir] $::teapotservers [my package_name] $os $cpu
  }

  ###
  # topic: 04bf4e304e2a01a2fb5321797785b224cbf6a954
  ###
  method recipe-vfs-install path {
    my teapot_download $path
  }

  ###
  # topic: db2818aa1d45f5d02d57e207f210e315c0492536
  ###
  method recipe-download {} {}

  ###
  # topic: 281e918c567c462cf39173f2d60c46be375354cb
  ###
  method build-clean {} {}

  ###
  # topic: 466890e6b36114f69456a2ba0f0432cb6e91fa38
  ###
  method gort_vfs_install path {
    my teapot_download $path
  }

  ###
  # topic: 569dc69d00acd89dbd07214c97d0269951064ebd
  ###
  method teapot_download path {
    my build-toolset
    # Allow a locally downloaded version to outrank the teapot
    set platform [::localtool teapot get platform]
    set local_cache [file join $::gort(teapot) $platform]
    foreach file [glob -nocomplain [file join ${local_cache} [my package_name]]*] {
      puts "USING LOCAL COPY [file tail $file]"
      copy_path $file [file join $path [my package_name]]
      return
    }
    set os  [my <toolset> teapot get os]
    set cpu [my <toolset> teapot get cpu]
    puts "DOWNLOADING [my package_name]"
    ::teapotclient::download_extensions $local_cache $::teapotservers [my package_name] $os $cpu
    foreach file [glob -nocomplain [file join ${local_cache} [my package_name]]*] {
      copy_path $file [file join $path [my package_name]]
      return
    }
    error "Teapot did not download [my package_name]"
  }
}

