###
# topic: b871a3a808d15a93c9b75eb2b698f1603815db31
###
gort::class create ::gort::recipe.tea {
  superclass gort::recipe.tclpkg
  
  property linked_statically 0
  property destroot_capabable 0
  
  method build-options {} {
    set opts [my define getnull configure_flags]
    if {$::gort(static) || $::gort(target) != "local"} {
      lappend opts "--with-tcl=[file join [[::gort::recipe_object tcl] path-build] tclConfig.sh]"
      if {[my define get package_binary_tk 0]==1} {
        lappend opts "--with-tk=[[::gort::recipe_object tk] path-build]"
      }
    }
    if {$::gort(static)} {
      lappend opts --enable-shared=no
    }
    return $opts
  }
  
  ###
  # topic: a79cae17064027202635bf19d0c1299505f22c7c
  ###
  method build_teapot_data {} {
    set buffer {}
    set dll [my define getnull package_lib_file]
    if { $dll != {} } {
      lappend included $dll
    }
    lappend included *.tcl
    append buffer \n [list Meta included {*}$included]
    return $buffer
  }

  ###
  # topic: 82d65306a47736bfd3b993cc70bc5474a8d8733c
  ###
  method recipe-vfs-install path {
    set lpath [my path-build]
    ###
    # Try to copy the latest version from source
    ###
    my recipe-detect-properties
    set exists [file exists [file join $lpath gort.rc]]
    set installpath [my install_path]
    puts [list recipe-vfs-install $exists]
    if {$exists} {
      ###
      # Use custom settings populated by autoconf in gort.rc
      ###
      file mkdir [file join $path lib $installpath]
      set mpath [my define getnull package_tcl_modules_root]
      if {$mpath ne {}} {
        set srcpath [file join $lpath $mpath]
        set modules [my define getnull package_tcl_modules]
        if {[llength $modules] < 1} {
          foreach mod [glob -nocomplain [file join $srcpath *]] {
            if {[file isdirectory $mod]} {
              lappend modules [file tail $mod]
            }
          }
        }
        foreach mod $modules {
          copy_path [file join $srcpath $mod] [file join $path lib $installpath $mod]
        }
      }
      set dll [my define getnull package_lib_file]
      if {[file exists [file join $lpath $dll]]} {
        file copy -force [file join $lpath $dll] [file join $path lib $installpath]
      }
      if {[file exists [file join $lpath pkgIndex.tcl]]} {
        file copy -force [file join $lpath pkgIndex.tcl] [file join $path lib $installpath]
      } else {
        # Use gort to synthesize in index file
        ::codebale::pkg_mkIndex [file join $path lib $installpath]
      }
      return
    }
    if {[::localtool platform get os] != "cygwin" && [string is false [my define get destroot_capabable]]} {
      my <toolset> make-install [my path-build] $path
      return
    }
    my <toolset> make-install [my path-build]
    copy_path [file join [my define get libdir] $installpath] [file join $path $installpath]
  }

  ###
  # topic: 7fe1a74312478cf2ac2cb4b639f40a63abcafeaf
  ###
  method recipe-download {} {
    next
    ###
    # Provide access to tclconfig if missing
    ###
    set source_path [my path-source]
    if {![file exists [file join $source_path tclconfig]]} {
      if {![file exists [file join $::gort(sandbox) tclconfig]]} {
        [::gort::recipe_object tclconfig] recipe-download
      }
      copy_path [file join $::gort(sandbox) tclconfig] [file join $source_path tclconfig]
    }
  }
}

###
# topic: 00941fef3424232617d58a2b5698d3011cc47cb1
###
gort::class create ::gort::recipe.cthulhu {
  superclass gort::recipe.tclpkg

  ###
  # topic: 394304c9733ccd7b6a3def926a6b9a02d8ea2e84
  ###
  method recipe-vfs-install path {
    set lpath [my path-build]
    ###
    # Try to copy the latest version from source
    ###
    my recipe-detect-properties
    set installpath [my install_path]
    if {[file exists [file join $lpath gort.rc]]} {
      ###
      # Use custom settings populated by autoconf in gort.rc
      ###
      file mkdir [file join $path lib $installpath]
      set mpath [my define getnull package_tcl_modules_root]
      if {$mpath ne {}} {
        set srcpath [file join $lpath $mpath]
        set modules [my define getnull package_tcl_modules]
        if {[llength $modules] < 1} {
          foreach mod [glob -nocomplain [file join $srcpath *]] {
            if {[file isdirectory $mod]} {
              lappend modules [file tail $mod]
            }
          }
        }
        foreach mod $modules {
          copy_path [file join $srcpath $mod] [file join $path lib $installpath $mod]
        }
      }
      set dll [my define getnull package_lib_file]
      if {[file exists [file join $lpath $dll]]} {
        file copy -force [file join $lpath $dll] [file join $path lib $installpath]
      }
      if {[file exists [file join $lpath pkgIndex.tcl]]} {
        file copy -force [file join $lpath pkgIndex.tcl] [file join $path lib $installpath]
      } else {
        # Use gort to synthesize in index file
        ::command::module_index [file join $path lib $installpath]
      }
    } elseif {[::localtool platform get os] != "cygwin" && [my define get destroot_capabable 0]} {
      my <toolset> make-install [my path-build] $path
    } else {
      cd [my path-build]
      my <toolset> make-install [my path-build]
      copy_path [file join [my define get libdir] $installpath] [file join $path lib $installpath]
    }
  }

  ###
  # topic: 810e201bcfc6ea52565bca1ef43d0d2790a17047
  ###
  method recipe-skip {} {
    return 0
  }
}

