###
# topic: 542ea0b11ce3641f8b58200a3eb6d7d36df1580d
# description:
#    Tcllib, Tklib, and Odielib are all distributed
#    by fossil and have a similiar structure based on
#    aku's "Swiss Army Knife", sak
###
gort::class create ::gort::recipe.sak {
 superclass gort::recipe.tclpkg
  
  property package_binary 0
  property package_binary_tk 0
  
  ###
  # topic: 9037462ed7a230896ad02d1e0b8b987fc20841a3
  ###
  method path-build {} {
    return [my path-module]
  }

  ###
  # topic: 9037462ed7a230896ad02d1e0b8b987fc20841a3
  ###
  method path-source {} {
    return [my path-module]
  }
  
  method recipe-build {} {}
  
  ###
  # topic: bc5bdee250ed4f227050303dafb902b60e4acb45
  ###
  method recipe-install {} {
    set hpath [my path-build]

    set mainmod {}
    set data [exec $::gort(tclsh) [file join $hpath sak.tcl] critcl-modules]
    foreach line [split $data \n] {
      if {[lindex $line 1] eq "**"} {
        set mainmod [lindex $line 0]
      }
    }

    doexec $::gort(tclsh) [file join $hpath installer.tcl] \
            -pkg-path [file join $::gort(prefix) lib [my define get module_name]] \
            -no-examples -no-html -no-nroff \
            -no-wait -no-gui -no-apps
    foreach file [glob -nocomplain [file join $hpath apps *]] {
      set exename [file tail $file]
      set destexe [file join [my <toolset> define-get bindir] $exename]
      if {[file exists $destexe]} {
        my install_app $file $destexe
      }
    }
    if {$mainmod ne {}} {
      puts [list C ACCELLERATED MODE $mainmod]
      doexec $::gort(tclsh) [file join $hpath sak.tcl] critcl
      copy_path [file join $hpath modules $mainmod] [file join $::gort(prefix) lib $mainmod]
    }
    my recipe-register
  }

  ###
  # topic: 09819fd88a754081a39506b4d19b82e1e6157aef
  ###
  method recipe-vfs-install path {
    package require codebale
    set hpath [my path-build]
    doexec $::gort(tclsh) [file join $hpath installer.tcl] \
            -pkg-path [file join $path lib [my package_name]] \
            -no-examples -no-html -no-nroff \
            -no-wait -no-gui -no-apps
    ###
    # The packageing system for SAK assumes we can introspect
    # paths, which doesn't work in VFS
    ###
    if {[file exists $path/pkgIndex.tcl]} {
      file delete $path/pkgIndex.tcl
    }
    ::codebale::pkg_mkIndex $path
  }

  ###
  # topic: 2e83e47e5176a1e7ec81304b67200116d2cb1c5f
  ###
  method recipe-vfs-install_package {path pkg} {
    set hpath [my path-build]
    foreach file [glob [file join $hpath modules $pkg *.tcl]] {
      set fname [file tail $file]
      #if { $fname eq "pkgIndex.tcl"} continue
      copy_path $file [file join $path lib [my define getnull package_name] $pkg $fname]
    }
  }

  ###
  # topic: 16dbbc25f88ffe43be5af49113a8cd5599e82c33
  ###
  method teapot_vfs_structure path {
  }
}

