###
# Special handling of modules that implement Tcl packages
###

###
# topic: e72f11c057a33a93f8e6d0015b1af1b2e0e02c5c
# title: Buildsystem for a generic Tcl package
###
gort::class create ::gort::recipe.tclpkg {
  superclass gort::recipe ::gort::recipe.shellpkg
  meta set classinfo type: core
  meta branchset define {
    package_version {}
    package_name {}
    package_binary 1
    property package_binary_tk 0
    property package_requires {}
    property live_install 0
  }
  ###
  # topic: cb4f34bd096d4555166e60f09ff7a55690ac9418
  ###
  method build_done {} {
    if {$::gort(static) || $::gort(target) != "local"} {
      return 0
    }
    set cachefile [my teapot_cachefile]
    if {[file exists $cachefile]} {
      return 1
    }
    return [file exists [file join [my define get libdir] [my install_path]]]
  }

  ###
  # topic: 8ccc41c0af92eaafef3f27a6f162e6ab217d0f93
  ###
  method build_teapot_data {} {}

  ###
  # topic: 580b44076d60df09f4ed203813f95379cc781589
  ###
  method distribution_teapot_data {} {}

  ###
  # topic: 56d302599a78732892ddaa2e6153c181f32070b4
  ###
  method install_path {} {
    my variable installpath
    if {![info exists installpath]} {
      set installpath [my define getnull install_path]
    }
    if {$installpath eq {}} {
      set installpath [file join [my package_name][my package_version]]
    }
    return $installpath
  }

  ###
  # topic: ce9cf7ed8ac2896cce54265846e90eb01d5ec352
  ###
  method package_name {} {
    variable packagename
    if {![info exists packagename]} {
      set packagename [my define getnull package_name]
    }
    if {$packagename eq {}} {
      set data [my recipe-detect-properties]
      if {[dict exists $data package_name]} {
        set packagename [dict get $data package_name]
      }
    }
    if {$packagename eq {}} {
      set packagename [my define getnull module]
    }
    return $packagename
  }

  ###
  # topic: 1a4e918346593eb2b8ad024fbc229692b9b506de
  # title: Return list of packages required by this package
  ###
  method package_requires {} {
    set requirements [my define getnull package_requires]
    lappend requirements tcl
    return $requirements
  }

  ###
  # topic: 043eed5bdfd7159e3283aaa9ef245b802bf4a5d7
  ###
  method package_version {} {
    my variable packageversion config
    if {![info exists packageversion]} {
      set packageversion [my define getnull package_version]
    }
    if {$packageversion eq {}} {
      set data [my recipe-detect-properties]
      if {[dict exists $data package_version]} {
        set packageversion [dict get $data package_version]
      }
    }
    return $packageversion
  }

  ###
  # topic: 229788731b3cfbd4f7ffb90e1cfcaa2389fd1eeb
  ###
  method recipe-build {} {
    if {[my recipe-skip]} {return 1}
    if {$::gort(static) || $::gort(target) != "local"} {
      foreach pkg [my package_requires] {
        puts "CHECKING PREQUISITE $pkg"
        set obj [::gort::recipe_object $pkg]
        puts [list SELF [self] OBJ $obj]
        if {$obj ne {} && $obj ne [self]} {
          $obj recipe-build
        }
      }
      return [next]
    }
    set cachefile [my teapot_cachefile]
    if {[file exists $cachefile]} {
      return 1
    }
    return [next]
  }
  

  
  ###
  # topic: d45add6e6087fe728b267d9065daf0a8c6b8db39
  ###
  method build-clean {} {
    my make_env
    set cachefile [my teapot_cachefile]
    if {[file exists $cachefile]} {
      file delete $cachefile
    }
    set path [my path-build]
    set vfsdir $path/teapot.vfs
    if {[file exists $path/teapot.zip]} {
      file delete $path/teapot.zip
    }
    if {[file exists $vfsdir]} {
      file delete -force $vfsdir
    }
    
    my <toolset> build-clean
  }

  ###
  # topic: 17d168720b37f104793b7e1fdd5e6fbcc492d39c
  ###
  method recipe-present {} {
    if {$::gort(static) || $::gort(target) != "local"} {
      return 0
    }
   if {![string is true -strict [::gort::meta_get [my define getnull module_name] installed]]} {
    puts "Not installed"
      return 0
    }
    set cachefile [my teapot_cachefile]
    if {![file exists $cachefile]} {
      puts "No cachefile"
      return 0
    }
    return 1
  }

  ###
  # topic: c60fdd6038772b5ccee71c7ebd6d8451da157f0f
  ###
  method gort_vfs_install path {
    if {[my recipe-skip]} return
    if {[string is true -strict [my define get live_install 0]]} {
      my recipe-build
      # Bypass the cache, if so configured
      my recipe-vfs-install $path
    } else {
      set cachefile [my teapot_cachefile]
      if {![file exists $cachefile]} {
        my recipe-build
        my teapot_build
      }
      file mkdir $path/teapot
      ::command::archive::unzip $cachefile $path/teapot/[::md5::md5 -hex [my teapot_package_name]]
    }
  }

  ###
  # topic: 8736ec3bce0331a4fe9885ef859184a1066e401d
  ###
  method teapot_arch {} {
    if {[my define get package_binary 0]==1} {
      if {[my define get package_binary_tk 0]==1} {
        return binary_tk
      } else {
        return binary
      }
    }
    return tcl
  }

  ###
  # topic: 71f509eb9259f1d1df33bb13f22d89f2ad34fe2e
  ###
  method teapot_build {} {
    puts "Packaging [my define getnull module_name] for the TEAPOT"
    set path [my path-build]
    set vfsdir $path/teapot.vfs
    if {[file exists $path/teapot.zip]} {
      file delete $path/teapot.zip
    }
    if {[file exists $vfsdir]} {
      file delete -force $vfsdir
    }
    file mkdir $vfsdir
    my recipe-vfs-install $vfsdir
    my teapot_vfs_structure $vfsdir
    if {![file exists $vfsdir/teapot.txt]} {
      set fout [open $vfsdir/teapot.txt w]
      puts $fout [my teapot_info]
      close $fout
    }
    ::command::archive::zip $path/teapot.zip $vfsdir
       
    set cachefile [my teapot_cachefile]
    puts "[my define getnull module_name] CACHE $cachefile"
    if {[file exists $cachefile]} {
      file delete $cachefile
    }
    file copy -force $path/teapot.zip $cachefile
    file copy -force $vfsdir/teapot.txt [file rootname $cachefile].txt
    #file delete -force $vfsdir
  }

  ###
  # topic: 56d7cdff4ffc7f09f9d335696435a91229d1e3c4
  ###
  method teapot_cachefile {} {
    set name [my teapot_package_name]
    set ver  [my package_version]
    switch  [my teapot_arch] {
      tcl { set arch tcl }
      binary - binary_tk {
        if {$::gort(target) eq "local"} {
          set arch local
        } else {
          set arch $::gort(target)
        }
      }
    }
    file mkdir [file join $::gort(teapot) $arch]
    set cachefile [file join $::gort(teapot) $arch [my package_name][my package_version].zip]
    return $cachefile
  }

  ###
  # topic: ef956efb3a17ac8a857c13ea838829b1a5fba54e
  # description: Synthesize a teapot.txt file if missing
  ###
  method teapot_info {} {
    set path [my path-build]
    if {[file exists $path/teapot.txt]} {
      set fin [open $path/teapot.txt r]
      set dat [read $fin]
      close $fin
      return $dat
    }
    set buffer {}
    append buffer [list Package [my package_name] [my package_version]]
    append buffer \n [list Meta platform [my teapot_arch]]    
    foreach {pkg} [my package_requires] {
      append buffer \n [list Meta require $pkg]
    }
    append buffer [my build_teapot_data]
    append buffer [my <distribution> teapot_data]

  
    append buffer \n \n [list Meta description {This package was autogenerated from source by Gort}]
    append buffer \n [list Meta description {More information will become available}]
    append buffer \n
    
    foreach {var val} [my meta dump] {
      append buffer \n [list Meta gort_property $var $val]
    }
    return $buffer
  }

  ###
  # topic: b63de71d34c14bb73986d01f632bc97544c681c6
  ###
  method teapot_package_fqn {} {
    my variable config

    set arch tcl
    switch [my teapot_arch] {
      binary {
        set arch [::localtool teapot get platform]
      }
      binary_tk {
        set arch [::localtool teapot get platform_tk]
        if {$arch eq {}} {
          set arch [::localtool teapot get platform]
        }
      }
    }
    set package_fqn package/name/[my package_name]/ver/[my package_version]/arch/$arch/file
  }

  ###
  # topic: 9c1c774105cc504f6c51979e6cda3193c65537a3
  ###
  method teapot_package_name {} {
    my variable package_fqn
    if {[info exists package_fqn]} {
      return $package_fqn
    }
    set package_fqn [my teapot_package_fqn]
    return $package_fqn
  }

  ###
  # topic: 3390899b9958cb3e7893b6145a76a0445ad82695
  ###
  method teapot_vfs_structure path {
    ###
    # Attempt to bring all of the key parts to the top level directory
    ###
    set ipath [my install_path]
    if {[file exists $path/$ipath]} {
      foreach item [glob $path/$ipath/*] {
        file rename $item $path/[file tail $item]
      }
      file delete $path/$ipath
    }
  }
}

###
# topic: d645e64c5b6474526edc5e5bb1219038757bb1de
###
gort::class create ::gort::recipe.tcllibrary {
  superclass gort::recipe.tclpkg

  ###
  # topic: 7af5c06589632e1d22b8041dec7e7c2f910f1b4e
  ###
  method recipe-install {} {
    set srcpath [my path-module]
    set dpath [file join [my <toolset> define-get libdir] [my define getnull package_name][my define getnull package_version]]
    file delete -force $dpath

    foreach modpath [glob -nocomplain [file join $srcpath modules *]] {
      set mdpath [file join $dpath [file tail $modpath]]
      copy_path $modpath $mdpath
      if {[file exists [file join $mdpath pkgIndex.tcl]]} {
        file delete [file join $mdpath pkgIndex.tcl]
      }
    }
    foreach file [glob -nocomplain [file join $srcpath apps *]] {
      set exename [file tail $file]
      set destexe [file join [my <toolset> define-get bindir] $exename]
      if {[file exists $destexe]} {
        my install_app $file $destexe
      }
    }
    ::codebale::pkg_mkIndex $dpath
  }

  ###
  # topic: 37f3e43420744781e4bc615d733217e8015d9aa0
  ###
  method recipe-vfs-install path {
    set srcpath [my path-module]
    set dpath [file join $path lib [my define getnull package_name][my define getnull package_version]]
    file delete -force $dpath
    foreach modpath [glob -nocomplain [file join $srcpath modules *]] {
      copy_path $modpath [file join $dpath [file tail $modpath]]
    }
  }

  ###
  # topic: 0d801e7d7a6955dac3da0c8404752b5cebbefd04
  ###
  method teapot_arch {} {
    return tcl
  }
}

