###
# topic: a7e2c9730e1ad360564fd0a880cb084f488e5a46
###
gort::class create ::gort::recipe {
  superclass
    
  define package_name {}
  define package_version {}
  define package_platform {}
  define compile_after {}
  define module_name generic
  define active 1
  property options_strict 0
  define compile_after {}
  define module_name generic
  property gort active 1
  property gort skip 0

  constructor {properties} {
    my variable define
    foreach {field value} $properties {
      set define([string trimright ${field} :]) $value
    }
    my graft toolset [::gort::toolset create [namespace current]::toolset [self]]
    my graft distribution [::gort::distribution create [namespace current]::distro [self]]
    set final_class [my select]
    if {[info commands $final_class] ne {}} {
      # Safe to switch class here, we haven't initialized anything
      oo::objdefine [self] class $final_class
    }
    oo::objdefine [self] [my define getnull oo_define]
    if {$::env(GORT_DEBUG)} {
      puts [list RECIPE [self]]
      puts [parray define]
      puts [list CLASS [info object class [self]] [my select]]
      puts [list TOOLSET [info object class [my organ toolset]]]
      puts [list DISTRO  [info object class [my organ distribution]]]
      puts [list SOURCE [my path-source]]
    }
    my initialize
  }

  method select {} {
    set type [my define getnull type]
    if {$type eq "tclmake"} {
    }
    if {$type ne {}} {
      if {[info command $type] ne {}} {
        return $type
      }
      if {[info command ::gort::recipe.$type] ne {}} {
        return ::gort::recipe.$type
      }
      if {[info command ::gort::recipe/$type] ne {}} {
        return ::gort::recipe/$type
      }
    }
    switch [my define getnull toolset] {
      sak {
        return ::gort::recipe.sak
      }
      tea {
        return ::gort::recipe.tea
      }
    }
    # Default to a tcl package
    return ::gort::recipe.tclpkg
  }

  method build_done {} {
    return 0
  }
  
  ###
  # topic: 631ff899685c83ff00c32762350857b039f5f322
  ###
  method build_meta_data {} {
    return {}
  }
  
  ###
  # topic: 920a310a0740d37ff4e81c5d900e09de3b765e1e
  # title: Convert a windows fully qualified path to something compadible with msys commands
  ###
  method dewinify fname {
    if {[string index $fname 1] ne ":"} {
      return $fname
    }
    return "/[string index $fname 0][string range $fname 2 end]"
  }

  ###
  # topic: 3d8616866c4c2689d8b3ac3aa46b5a3f270a94c7
  ###
  method recipe-download {} {}

  ###
  # topic: ae8e30e8c6b0c67c62aab286ae6d342e3dd1291e
  ###
  method distribution_upgrade {} {
    return 0 
  }

  ###
  # topic: 3431baa3589b88ca64cd8bd53a91dc7cd67a05e4
  ###
  method install_app {src dest} {
    set fin [open $src r]
    set fout [open $dest w]
    gets $fin line
    if {[string trim $line] eq {#! /usr/bin/env tclsh}} {
      puts $fout "#! [list $::gort(tclsh)]"
    } elseif {[string trim $line] eq {#! /usr/bin/env wish}} {
      puts $fout "#! [list $::gort(wish)]"
    } else {
      while {[gets $fin line] >= 0} {
        if {[string index $line 0] != "#" } break
        puts $fout $line
      }
      if {[string range $line 0 10] eq "exec tclsh "} {
        puts $fout "exec [list $::gort(tclsh)] \"\$0\" \$\{1+\"\$@\"\}"
      } elseif {[string range $line 0 9] eq "exec wish "} {
        puts $fout "exec [list $::gort(wish)] \"\$0\" \$\{1+\"\$@\"\}"
      } else {
        puts $fout $line
      }
    }
    puts $fout [read $fin]
    close $fin
    close $fout
    exec chmod a+x $dest
  }

  ###
  # topic: 1013a5ed6dc808b3ee345f54adc769adc7a9d86a
  ###
  method install_capp {src dest} {
    ::gort::make_env
    global odie
    file delete $dest
    set ofile [file rootname $dest].o
    ::compile -o $ofile -c $src
    ::compile $ofile -o $dest
    file delete $ofile
    doexec chmod a+x $dest
  }

  ###
  # topic: 52035786b7788f6e99a2350b93f43874a35dfc6e
  ###
  method install_forward {src dest} {
    set fin [open $src r]
    set fout [open $dest w]
    gets $fin line
    if {[string trim $line] eq {#! /usr/bin/env tclsh}} {
      puts $fout "#! [list $::gort(tclsh)]"
    } elseif {[string trim $line] eq {#! /usr/bin/env wish}} {
      puts $fout "#! [list $::gort(wish)]"
    } else {
      while {[gets $fin line] >= 0} {
        if {[string index $line 0] != "#" } break
        puts $fout $line
      }
      if {[string range $line 0 10] eq "exec tclsh "} {
        puts $fout "exec [list $::gort(tclsh)] \"\$0\" \$\{1+\"\$@\"\}"
      } elseif {[string range $line 0 9] eq "exec wish "} {
        puts $fout "exec [list $::gort(wish)] \"\$0\" \$\{1+\"\$@\"\}"
      } else {
        puts $fout $line
      }
    }
    puts $fout [list source $src]
    close $fin
    close $fout
    exec chmod a+x $dest
  }

  ###
  # topic: 9037462ed7a230896ad02d1e0b8b987fc20841a3
  ###
  method path-build {} {
    my varname module_build
    if {![info exist module_build]} {
      set target $::gort(target)
      if {$target eq {}} {
        set target local
      }
      if {$::gort(static)} {
        set target static-$target
      }
      set module_build [file normalize [file join $::gort(sandbox) build $target [my define getnull module_name]]]
      if {![file exists $module_build]} {
        file mkdir $module_build
      }
    }
    return $module_build
  }

  ###
  # topic: 9037462ed7a230896ad02d1e0b8b987fc20841a3
  ###
  method path-module {} {
    my varname module_path
    if {![info exists module_path]} {
      set module_path [::gort::project_source [my define getnull module_name] exists]
      if {!$exists} {
        file mkdir $module_path
      }
    }
    return $module_path
  }

  ###
  # topic: 9037462ed7a230896ad02d1e0b8b987fc20841a3
  ###
  method path-source {} {
    return [my path-module]
  }

  method build-options {} {
    return [my define getnull configure_flags]
  }

  ###
  # topic: 3d5c73206c0376ad9de91e059b10967023f1cc49
  ###
  method package_requires {} {
    return [my define getnull package_requires]
  }

  ###
  # topic: e31d7d6e2737e0528efd2104bfed8dfe55526f79
  # title: Steps it prepare a package for installation without actually installing
  ###
  method recipe-build {} {
    #if {[my recipe-present]} {return 1}
    #if {[my recipe-skip]} {return 1}
    my <distribution> download [my path-module]
    if {![my <toolset> make-is-configured [my path-build]]} {
      my <toolset> make-configure [my path-source] [my path-build] {*}[my build-options]
      my <toolset> make-clean [my path-build]
    }
    if {[my build_done]} {
      return 0
    }
    my recipe-detect-properties 1
    my <toolset> make-all [my path-build]
    return 0
  }

  ###
  # topic: afad93529755bd0d5e77bef9d5f1e427436be906
  ###
  method recipe-detect-properties {{force 0}} {
    my variable config autoprops
    if {!$force && [info exists autoprops]} {
      return $autoprops
    }
    set autoprops {}
    foreach {var val} [my <toolset> detect-metadata [my path-module] [my path-build]] {
      dict set autoprops  [string trimright $var :] $val
      dict set config [string trimright $var :] $val
    }
    foreach {var val} [my <distribution> detect-metadata [my path-module]] {
      dict set autoprops  [string trimright $var :] $val
      dict set config [string trimright $var :] $val
    }
    return $autoprops
  }
  
  ###
  # topic: a03f9f93e86e551565a39776287043bd9dffcfc8
  ###
  method recipe-install {} {
    if {[my recipe-build]} {
      return
    }
    my <toolset> make-install [my path-build]
    my recipe-register
  }

  ###
  # topic: 76c4ec71ca72b596c9084ac65aa4d711a95c3c3c
  ###
  method recipe-present {} {
    if {$::gort(static) || $::gort(target) != "local"} {
      return 0
    }
    return [string is true -strict [::gort::meta_get [my define getnull module_name] installed]]
  }

  ###
  # topic: 8b98b9266b3c2131c3bd69995db627e1e620c06d
  ###
  method recipe-register {} {
    set mod [my define getnull module_name]
    ::gort::meta_clear $mod
    foreach {field value} [my <distribution> detect-metadata [my path-module]] {
      ::gort::meta_put $mod $field $value
    }
    ::gort::meta_put $mod installed 1
  }

  ###
  # topic: 63a8f679a1eae40dfea605d472ac4598cd925a39
  ###
  method recipe-skip {} {
    return 0
  }

  ###
  # topic: 13b92c3ca67cd092192b45b714b7ea8d93c8de92
  ###
  method recipe-uninstall {} {
    my <toolset> make-clean [my path-build]
    my recipe-unregister
  }

  ###
  # topic: 669d020a89e25bb8307d92cb4dfd9db3fb7ce77b
  ###
  method recipe-unregister {} {
    ::gort::meta_put [my define getnull module_name] installed 0
  }

  ###
  # topic: a18bcc49f312840755f29c0b871d9688ca1d5648
  ###
  method recipe-upgrade {} {
    if {![my recipe-present]} {
      return 0
    }
    if {![file exists [my path-module]]} {
      my <distribution> download [my path-module]
      my recipe-install
      return 1
    }
    if {![my <distribution> upgrade [my path-module]]} {
      return 0
    }
    puts "New version of [my define getnull module_name] available. Rebuilding..."
    my <toolset> make-clean
    my recipe-build
    my teapot_build
    my recipe-install
    return 1
  }

  ###
  # topic: f46d8add0c1f278f6105fd76c28803b75c238f6f
  ###
  method test {} {}
}

# For targets which could be included statically
gort::class create ::gort::recipe.shellpkg {
  define static_candidate 1
  
  method build-options {} {
    set opts [my define getnull configure_flags]
    if {$::gort(static) || $::gort(target) != "local"} {
      lappend opts "--with-tcl=[[::gort::recipe_object tcl] path-build]"
    }
    if {$::gort(static)} {
      lappend opts --enable-shared=no
    }
    return $opts
  }
  
  method recipe-integrate {} {
    my recipe-build
    set bpath [my path-build]
    set info {}
    dict set info libfile [file join $bpath [my static-library]]
    dict set info initfunct [my static-initfunct]
    return $info
  }
  
  method static-initfunct {} {
    set pname [my package_name]
    set Pname [string totitle $pname]
    return [string map [list $pname %PNAME% $Pname %Pname%] {
  if(%Pname%_Init(interp)) return TCL_ERROR;
    }]
  }
  
  method static-library {} {
    return lib[my package_name][my package_version].a
  }
}

