###
# This script is evaluated within the emerging toolset object
###
my variable config define platform profile_tcl profile_tk odie teapot
if {![info exists config]} {
  set config {}
}    

my teapot set cpu generic
my teapot set os  generic
  
my teapot set profile    gort-[my tcl get version]

set uname [::gort::find-EXE uname]
if {$uname eq {}} {
  return
}

###
# Tools for systems where the "uname" command is available
###

# Make sure srcdir is fully qualified!
set cpu [exec uname -m]
set os  [exec uname -s]
my teapot set platform   [::platform::identify]
my teapot set target     [::platform::generic]
my platform set os $os
my platform set cpu $cpu
my platform set system $os-$cpu
my platform set windows 0
my teapot   set cpu $cpu
my platform set 64bit [expr {$cpu in {amd64 x64 x86_64}}]
set vfscp {cp -a} 

if {[dict exists $config build] && [dict get $config build] ni {local {}}} {
  set build [dict get $config build]
} else {
  # Start Local
  set build [string tolower [exec uname -p]-unknown-[exec uname -s][exec uname -r]]
  dict set config build local
}
my platform set build $build
switch -glob -- $build {
  macosx* -
  *-*-darwin* {
    # Use a native tool
    set verdat [exec sw_vers]
    foreach line [split $verdat \n] {
      if {[lindex $line 0] eq "ProductVersion:"} {
        set os_version [lindex $line 1]
        my platform set os_version $os_version
        break
      }
    }
    my platform set os macosx
    my teapot set os macosx
    ###
    # Detect universal or x86_64
    ###
    set major [lindex [split $os_version .] 1]
    if { $major < 4 || $cpu != "x86_64"} {
      my teapot set os macosx
      my teapot set platform macosx-universal
      my teapot set cpu universal
    } else {
      my teapot set os macosx10.5
      my teapot set platform macosx10.5-i386-x86_64
      my teapot set cpu x86_64
    }
    my platform set source_platform_dir macosx
  }
  win32-x86_64 -
  win32-ix86 -
  *-*-ming* - *-*-cygwin - *-*-msys - *win32*  {
    ###
    # With visual studio, 64 bit should be assumed
    # but is otherwise to taste
    ###
    my platform set platform windows
    my platform set os windows
    my platform set windows 1
    my platform set system $os-$cpu
    my teapot set os win32
    my platform set fossil_checkout _FOSSIL_
    my platform set source_platform_dir win
    my tcl set platform_source_dir win
    my tk set platform_source_dir win
    
    set vfscp {cp -a --no-preserve=links}

    if {[my platform get 64bit]} {
      my teapot set platform win32-ix86
      my platform set cpu ix86
    } else {
      my teapot set platform win32-x86_64
      my platform set cpu x86_64
    }
    my platform set exe_suffix .exe
  }
  linux-* -
  *-*-linux* {
    set glibcver [exec ldd --version]
    set major [lindex [split $glibcver .] 0]
    set minor [lindex [split $glibcver .] 1]
    my teapot set os linux-glibc$major.$minor
    my platform set system linux-[my platform get cpu]
    my platform set os linux
  }
}

