::namespace eval ::localtool {}
gort::class create ::gort::platform.windows {
  superclass ::gort::platform
  define exe_suffix .EXE
  
  method is_windows {} {
    return 1
  }

  ###
  # topic: b470ea93e3ae076306f333d6b79920da300de478
  ###
  method default-exec-prefix {} {
    return C:/tcl
  }
  
  ###
  # topic: 8b002e4a75f6a131ba48ae99642990a6e8679c63
  ###
  method default-prefix {} {
    return C:/tcl
  }
  
  ###
  # topic: 70337e6971b4d62668b10463d568939b90441f41
  ###
  method default-tcl-prefix {} {
    return C:/tcl
  }

  ###
  # topic: 825cd25953c2cc896a96006b7f454e00
  # title: Return pairings of MAC numbers to IP addresses on the local network
  # description: Under macosx, we call the arp command for arp table resolution
  ###
  method network-arp_table {} {
    set result {}
    catch {
    foreach element [::twapi::get_arp_table] {
      foreach {ifidx macid ipaddr type} {
        lappend result [string map {- :} $macid] $ipaddr
      }
    }
    }
    return $result
  }
  
  ###
  # topic: 92ebbfa155883ad41c37d3f843392be4
  # title: Return list of broadcast addresses for local networks
  ###
  method network-broadcast_list {} {
    set result {}
    lappend result 127.0.0.1
    foreach iface [::twapi::get_netif_indices] {
      set dat [::twapi::GetIpAddrTable $iface]
      foreach element $dat {
        foreach {addr ifindx netmask broadcast reamsize} $element break;
        lappend result [::ip::broadcastAddress $addr/$netmask]
      }
    }
    return [lsort -unique -dictionary $result]
  }
  
  ###
  # topic: 57fdc331bc60c7bf2bd3f3214e9a906f
  ###
  method network-hwaddr_to_ipaddr args {
    return [::twapi::hwaddr_to_ipaddr {*}$args]
  }
  
  ###
  # topic: dd2e2c0810cea69909399808f2a68949
  # title: Return a list of unique hardware ids
  ###
  method hwid_list {} {
    # Use the serial number on the hard drive
    catch {exec {*}[auto_execok vol] c:} voldat
    set num [lindex [lindex [split $voldat \n] end] end]
    return 0x[string map {- {}} $num]
  }
      
  ###
  # topic: 4b87d977492bd10802bfc0327cd07ac2
  # title: Return list of network interfaces
  ###
  method network-interfaces {} {
    return [::twapi::get_netif_indices]
  }
  
  method network-ip_list {} {
    ###
    # topic: 417672d3f31b80d749588365af88baf6
    # title: Return list of ip addresses for this computer (primary first)
    ###
    set body {}
    if {[::twapi::get_ip_addresses] ne {}} {
      set body {
    set result [::twapi::get_ip_addresses]
    ldelete result 127.0.0.1
    return $result
      } 
    } elseif {[info commands ::twapi::get_system_ipaddrs] ne {}} {
    # They changed commands names on me...
      set body {
    set result [::twapi::get_system_ipaddrs]
    ldelete result 127.0.0.1
    return $result
      }
    }
    # On the next call, use that body
    oo::objdefine [self] method network-ip_list {} $body
    # Return as if we ran that new body
    return [eval $body]
  }
  
  ###
  # topic: ac9d6815d47f60d45930f0c8c8ae8f16
  # title: Return list of mac numbers for this computer (primary first)
  ###
  method network-mac_list {} {
    set result {}
    foreach iface [::twapi::get_netif_indices] {
      foreach {field value} [::twapi::get_netif_info $iface -physicaladdress] {
        if { $value eq {} } continue
        lappend result [string map {- :} $value] 
      }
    }
    return $result
  }
  
  ###
  # topic: a43b6f42141820e0ba1094840d0f6fc0
  ###
  method network-network_list {} {
    set result {}
    foreach iface [::twapi::get_netif_indices] {
      set dat [::twapi::GetIpAddrTable $iface]
      foreach element $dat {
        foreach {addr ifindx netmask broadcast reamsize} $element break;
        set mask [::ip::maskToInt $netmask]
        set addri [::ip::toInteger $addr]
        lappend result [ip::nativeToPrefix [list [expr {$addri & $mask}] $netmask] -ipv4]    
      }
    }
    return [lsort -unique $result]
  }
  
  method path-real path {
    if {[string index $path 0] eq "/" && [string index $path 2] eq "/"} {
      return [string index $path 1]:[string range $path 2 end]
    }
    return $path
  }
  
  ###
  # The MSYS tries to make Windows Unix-like
  # by throwing out volume information
  ###
  method path-msys path {
    if {[string index $path 1] != ":" } { 
      return $path
    }
    set path [file-normalize $path]
    return /[string tolower [string index $path 0]][string range $path 2 end]
  }

  method status {} {
    set result {}
    #dict set result load [::twapi::]
    set cpus [::twapi::get_processor_count]
    set usage 0
    for {set p 0} {$p < $cpus} {incr p} {
      set pu  [lindex [::twapi::get_processor_info $p  -processorutilization] 1]
      set usage [expr {$usage+$pu}]
    }
    dict set result cpus $cpus
    dict set result load [expr {$usage/$cpus}]
    dict set result uptime [::twapi::get_system_uptime]
  }

  method tcl-shlib-name {package version} {
    return lib${package}[string map {. {}} ${version}][info sharedlibextension]
  }
  
  ###
  # topic: eb8a738d9222065f206b21654f52490082be2a11
  ###
  method user_data_root appname {
    return [file join $::env(APPDATA) $appname]
  }
  
  method as_teapot_location {} {
    return c:/Tcl/teapot
  }
}

gort::class create ::gort::platform::win32-ix86 {
  superclass ::gort::platform.windows
}

gort::class create ::gort::platform::win32-x86_64 {
  superclass ::gort::platform.windows
}

